/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.Util;

public final class SqlTypeName
extends Enum<SqlTypeName> {
    public static final /* enum */ SqlTypeName BOOLEAN = new SqlTypeName(1, false, 16, SqlTypeFamily.BOOLEAN);
    public static final /* enum */ SqlTypeName TINYINT = new SqlTypeName(1, false, -6, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName SMALLINT = new SqlTypeName(1, false, 5, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName INTEGER = new SqlTypeName(1, false, 4, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName BIGINT = new SqlTypeName(1, false, -5, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName DECIMAL = new SqlTypeName(7, false, 3, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName FLOAT = new SqlTypeName(1, false, 6, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName REAL = new SqlTypeName(1, false, 7, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName DOUBLE = new SqlTypeName(1, false, 8, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName DATE = new SqlTypeName(1, false, 91, SqlTypeFamily.DATE);
    public static final /* enum */ SqlTypeName TIME = new SqlTypeName(3, false, 92, SqlTypeFamily.TIME);
    public static final /* enum */ SqlTypeName TIMESTAMP = new SqlTypeName(3, false, 93, SqlTypeFamily.TIMESTAMP);
    public static final /* enum */ SqlTypeName INTERVAL_YEAR_MONTH = new SqlTypeName(1, false, 1111, SqlTypeFamily.INTERVAL_YEAR_MONTH);
    public static final /* enum */ SqlTypeName INTERVAL_DAY_TIME = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName CHAR = new SqlTypeName(3, false, 1, SqlTypeFamily.CHARACTER);
    public static final /* enum */ SqlTypeName VARCHAR = new SqlTypeName(3, false, 12, SqlTypeFamily.CHARACTER);
    public static final /* enum */ SqlTypeName BINARY = new SqlTypeName(3, false, -2, SqlTypeFamily.BINARY);
    public static final /* enum */ SqlTypeName VARBINARY = new SqlTypeName(3, false, -3, SqlTypeFamily.BINARY);
    public static final /* enum */ SqlTypeName NULL = new SqlTypeName(1, true, 0, SqlTypeFamily.NULL);
    public static final /* enum */ SqlTypeName ANY = new SqlTypeName(7, true, 2000, SqlTypeFamily.ANY);
    public static final /* enum */ SqlTypeName SYMBOL = new SqlTypeName(1, true, 1111, null);
    public static final /* enum */ SqlTypeName MULTISET = new SqlTypeName(1, false, 2003, SqlTypeFamily.MULTISET);
    public static final /* enum */ SqlTypeName ARRAY = new SqlTypeName(1, false, 2003, SqlTypeFamily.ARRAY);
    public static final /* enum */ SqlTypeName MAP = new SqlTypeName(1, false, 1111, SqlTypeFamily.MAP);
    public static final /* enum */ SqlTypeName DISTINCT = new SqlTypeName(1, false, 2001, null);
    public static final /* enum */ SqlTypeName STRUCTURED = new SqlTypeName(1, false, 2002, null);
    public static final /* enum */ SqlTypeName ROW = new SqlTypeName(1, false, 2002, null);
    public static final /* enum */ SqlTypeName OTHER = new SqlTypeName(1, false, 1111, null);
    public static final /* enum */ SqlTypeName CURSOR = new SqlTypeName(1, false, 2012, SqlTypeFamily.CURSOR);
    public static final /* enum */ SqlTypeName COLUMN_LIST = new SqlTypeName(1, false, 1113, SqlTypeFamily.COLUMN_LIST);
    public static final /* enum */ SqlTypeName DYNAMIC_STAR = new SqlTypeName(7, true, 2000, SqlTypeFamily.ANY);
    public static final int MAX_DATETIME_PRECISION = 3;
    public static final int DEFAULT_INTERVAL_START_PRECISION = 2;
    public static final int DEFAULT_INTERVAL_FRACTIONAL_SECOND_PRECISION = 6;
    public static final int MIN_INTERVAL_START_PRECISION = 1;
    public static final int MIN_INTERVAL_FRACTIONAL_SECOND_PRECISION = 1;
    public static final int MAX_INTERVAL_START_PRECISION = 10;
    public static final int MAX_INTERVAL_FRACTIONAL_SECOND_PRECISION = 9;
    private static final Map<String, SqlTypeName> VALUES_MAP;
    public static final List<SqlTypeName> ALL_TYPES;
    public static final List<SqlTypeName> BOOLEAN_TYPES;
    public static final List<SqlTypeName> BINARY_TYPES;
    public static final List<SqlTypeName> INT_TYPES;
    public static final List<SqlTypeName> EXACT_TYPES;
    public static final List<SqlTypeName> APPROX_TYPES;
    public static final List<SqlTypeName> NUMERIC_TYPES;
    public static final List<SqlTypeName> FRACTIONAL_TYPES;
    public static final List<SqlTypeName> CHAR_TYPES;
    public static final List<SqlTypeName> STRING_TYPES;
    public static final List<SqlTypeName> DATETIME_TYPES;
    public static final List<SqlTypeName> INTERVAL_TYPES;
    private static final Map<Integer, SqlTypeName> JDBC_TYPE_TO_NAME;
    private final int signatures;
    private final boolean special;
    private final int jdbcOrdinal;
    private final SqlTypeFamily family;
    private static final /* synthetic */ SqlTypeName[] $VALUES;

    public static SqlTypeName[] values() {
        return (SqlTypeName[])$VALUES.clone();
    }

    public static SqlTypeName valueOf(String name) {
        return Enum.valueOf(SqlTypeName.class, name);
    }

    private SqlTypeName(int signatures, boolean special, int jdbcType, SqlTypeFamily family) {
        this.signatures = signatures;
        this.special = special;
        this.jdbcOrdinal = jdbcType;
        this.family = family;
    }

    public static SqlTypeName get(String name) {
        return VALUES_MAP.get(name);
    }

    public boolean allowsNoPrecNoScale() {
        return (this.signatures & 1) != 0;
    }

    public boolean allowsPrecNoScale() {
        return (this.signatures & 2) != 0;
    }

    public boolean allowsPrec() {
        return this.allowsPrecScale(true, true) || this.allowsPrecScale(true, false);
    }

    public boolean allowsScale() {
        return this.allowsPrecScale(true, true);
    }

    public boolean allowsPrecScale(boolean precision, boolean scale) {
        int mask = precision ? (scale ? 4 : 2) : (scale ? 0 : 1);
        return (this.signatures & mask) != 0;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public int getJdbcOrdinal() {
        return this.jdbcOrdinal;
    }

    private static List<SqlTypeName> combine(List<SqlTypeName> list0, List<SqlTypeName> list1) {
        return ImmutableList.builder().addAll(list0).addAll(list1).build();
    }

    public int getDefaultScale() {
        switch (this) {
            case DECIMAL: {
                return 0;
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 6;
            }
        }
        return -1;
    }

    public SqlTypeFamily getFamily() {
        return this.family;
    }

    public static SqlTypeName getNameForJdbcType(int jdbcType) {
        return JDBC_TYPE_TO_NAME.get(jdbcType);
    }

    public Object getLimit(boolean sign, Limit limit, boolean beyond, int precision, int scale) {
        assert (this.allowsPrecScale(precision != -1, scale != -1)) : this;
        if (limit == Limit.ZERO) {
            if (beyond) {
                return null;
            }
            sign = true;
        }
        switch (this) {
            case BOOLEAN: {
                switch (limit) {
                    case ZERO: {
                        return false;
                    }
                    case UNDERFLOW: {
                        return null;
                    }
                    case OVERFLOW: {
                        if (beyond || !sign) {
                            return null;
                        }
                        return true;
                    }
                }
                throw Util.unexpected(limit);
            }
            case TINYINT: {
                return this.getNumericLimit(2, 8, sign, limit, beyond);
            }
            case SMALLINT: {
                return this.getNumericLimit(2, 16, sign, limit, beyond);
            }
            case INTEGER: {
                return this.getNumericLimit(2, 32, sign, limit, beyond);
            }
            case BIGINT: {
                return this.getNumericLimit(2, 64, sign, limit, beyond);
            }
            case DECIMAL: {
                BigDecimal decimal = this.getNumericLimit(10, precision, sign, limit, beyond);
                if (decimal == null) {
                    return null;
                }
                switch (limit) {
                    case OVERFLOW: {
                        BigDecimal other = (BigDecimal)BIGINT.getLimit(sign, limit, beyond, -1, -1);
                        if (decimal.compareTo(other) != (sign ? 1 : -1)) break;
                        decimal = other;
                    }
                }
                if (scale != 0) {
                    decimal = scale > 0 ? decimal.divide(BigDecimal.TEN.pow(scale)) : decimal.multiply(BigDecimal.TEN.pow(-scale));
                }
                return decimal;
            }
            case CHAR: 
            case VARCHAR: {
                if (!sign) {
                    return null;
                }
                StringBuilder buf = new StringBuilder();
                switch (limit) {
                    case ZERO: {
                        break;
                    }
                    case UNDERFLOW: {
                        if (beyond) {
                            return null;
                        }
                        buf.append("a");
                        break;
                    }
                    case OVERFLOW: {
                        for (int i = 0; i < precision; ++i) {
                            buf.append("Z");
                        }
                        if (!beyond) break;
                        buf.append("Z");
                    }
                }
                return buf.toString();
            }
            case BINARY: 
            case VARBINARY: {
                byte[] bytes;
                if (!sign) {
                    return null;
                }
                switch (limit) {
                    case ZERO: {
                        bytes = new byte[]{};
                        break;
                    }
                    case UNDERFLOW: {
                        if (beyond) {
                            return null;
                        }
                        bytes = new byte[]{0};
                        break;
                    }
                    case OVERFLOW: {
                        bytes = new byte[precision + (beyond ? 1 : 0)];
                        Arrays.fill(bytes, (byte)-1);
                        break;
                    }
                    default: {
                        throw Util.unexpected(limit);
                    }
                }
                return bytes;
            }
            case DATE: {
                Calendar calendar = Calendar.getInstance(DateTimeUtils.GMT_ZONE);
                switch (limit) {
                    case ZERO: {
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                        break;
                    }
                    case UNDERFLOW: {
                        return null;
                    }
                    case OVERFLOW: {
                        if (beyond) {
                            return null;
                        }
                        if (sign) {
                            calendar.set(1, 9999);
                            calendar.set(2, 11);
                            calendar.set(5, 31);
                            break;
                        }
                        calendar.set(1, 1);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                    }
                }
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                return calendar;
            }
            case TIME: {
                if (!sign) {
                    return null;
                }
                if (beyond) {
                    return null;
                }
                Calendar calendar = Calendar.getInstance(DateTimeUtils.GMT_ZONE);
                switch (limit) {
                    case ZERO: {
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        break;
                    }
                    case UNDERFLOW: {
                        return null;
                    }
                    case OVERFLOW: {
                        calendar.set(11, 23);
                        calendar.set(12, 59);
                        calendar.set(13, 59);
                        int millis = precision >= 3 ? 999 : (precision == 2 ? 990 : (precision == 1 ? 900 : 0));
                        calendar.set(14, millis);
                    }
                }
                return calendar;
            }
            case TIMESTAMP: {
                Calendar calendar = Calendar.getInstance(DateTimeUtils.GMT_ZONE);
                switch (limit) {
                    case ZERO: {
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        break;
                    }
                    case UNDERFLOW: {
                        return null;
                    }
                    case OVERFLOW: {
                        if (beyond) {
                            return null;
                        }
                        if (sign) {
                            calendar.set(1, 9999);
                            calendar.set(2, 11);
                            calendar.set(5, 31);
                            calendar.set(11, 23);
                            calendar.set(12, 59);
                            calendar.set(13, 59);
                            int millis = precision >= 3 ? 999 : (precision == 2 ? 990 : (precision == 1 ? 900 : 0));
                            calendar.set(14, millis);
                            break;
                        }
                        calendar.set(1, 1);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                }
                return calendar;
            }
        }
        throw Util.unexpected(this);
    }

    public int getMinPrecision() {
        switch (this) {
            case DECIMAL: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: 
            case TIME: 
            case TIMESTAMP: {
                return 1;
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 1;
            }
        }
        return -1;
    }

    public int getMinScale() {
        switch (this) {
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 1;
            }
        }
        return -1;
    }

    private BigDecimal getNumericLimit(int radix, int exponent, boolean sign, Limit limit, boolean beyond) {
        switch (limit) {
            case OVERFLOW: {
                BigDecimal bigRadix = BigDecimal.valueOf(radix);
                if (radix == 2) {
                    --exponent;
                }
                BigDecimal decimal = bigRadix.pow(exponent);
                if (sign || radix != 2) {
                    decimal = decimal.subtract(BigDecimal.ONE);
                }
                if (beyond) {
                    decimal = decimal.add(BigDecimal.ONE);
                }
                if (!sign) {
                    decimal = decimal.negate();
                }
                return decimal;
            }
            case UNDERFLOW: {
                return beyond ? null : (sign ? BigDecimal.ONE : BigDecimal.ONE.negate());
            }
            case ZERO: {
                return BigDecimal.ZERO;
            }
        }
        throw Util.unexpected(limit);
    }

    public SqlLiteral createLiteral(Object o, SqlParserPos pos) {
        switch (this) {
            case BOOLEAN: {
                return SqlLiteral.createBoolean((Boolean)o, pos);
            }
            case DECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return SqlLiteral.createExactNumeric(o.toString(), pos);
            }
            case CHAR: 
            case VARCHAR: {
                return SqlLiteral.createCharString((String)o, pos);
            }
            case BINARY: 
            case VARBINARY: {
                return SqlLiteral.createBinaryString((byte[])o, pos);
            }
            case DATE: {
                return SqlLiteral.createDate((Calendar)o, pos);
            }
            case TIME: {
                return SqlLiteral.createTime((Calendar)o, 0, pos);
            }
            case TIMESTAMP: {
                return SqlLiteral.createTimestamp((Calendar)o, 0, pos);
            }
        }
        throw Util.unexpected(this);
    }

    public String getName() {
        return this.toString();
    }

    static {
        $VALUES = new SqlTypeName[]{BOOLEAN, TINYINT, SMALLINT, INTEGER, BIGINT, DECIMAL, FLOAT, REAL, DOUBLE, DATE, TIME, TIMESTAMP, INTERVAL_YEAR_MONTH, INTERVAL_DAY_TIME, CHAR, VARCHAR, BINARY, VARBINARY, NULL, ANY, SYMBOL, MULTISET, ARRAY, MAP, DISTINCT, STRUCTURED, ROW, OTHER, CURSOR, COLUMN_LIST, DYNAMIC_STAR};
        VALUES_MAP = Util.enumConstants(SqlTypeName.class);
        ALL_TYPES = ImmutableList.of((Object)((Object)BOOLEAN), (Object)((Object)INTEGER), (Object)((Object)VARCHAR), (Object)((Object)DATE), (Object)((Object)TIME), (Object)((Object)TIMESTAMP), (Object)((Object)NULL), (Object)((Object)DECIMAL), (Object)((Object)ANY), (Object)((Object)CHAR), (Object)((Object)BINARY), (Object)((Object)VARBINARY), (Object[])new SqlTypeName[]{TINYINT, SMALLINT, BIGINT, REAL, DOUBLE, SYMBOL, INTERVAL_YEAR_MONTH, INTERVAL_DAY_TIME, FLOAT, MULTISET, DISTINCT, STRUCTURED, ROW, CURSOR, COLUMN_LIST});
        BOOLEAN_TYPES = ImmutableList.of((Object)((Object)BOOLEAN));
        BINARY_TYPES = ImmutableList.of((Object)((Object)BINARY), (Object)((Object)VARBINARY));
        INT_TYPES = ImmutableList.of((Object)((Object)TINYINT), (Object)((Object)SMALLINT), (Object)((Object)INTEGER), (Object)((Object)BIGINT));
        EXACT_TYPES = SqlTypeName.combine(INT_TYPES, (List<SqlTypeName>)ImmutableList.of((Object)((Object)DECIMAL)));
        APPROX_TYPES = ImmutableList.of((Object)((Object)FLOAT), (Object)((Object)REAL), (Object)((Object)DOUBLE));
        NUMERIC_TYPES = SqlTypeName.combine(EXACT_TYPES, APPROX_TYPES);
        FRACTIONAL_TYPES = SqlTypeName.combine(APPROX_TYPES, (List<SqlTypeName>)ImmutableList.of((Object)((Object)DECIMAL)));
        CHAR_TYPES = ImmutableList.of((Object)((Object)CHAR), (Object)((Object)VARCHAR));
        STRING_TYPES = SqlTypeName.combine(CHAR_TYPES, BINARY_TYPES);
        DATETIME_TYPES = ImmutableList.of((Object)((Object)DATE), (Object)((Object)TIME), (Object)((Object)TIMESTAMP));
        INTERVAL_TYPES = ImmutableList.of((Object)((Object)INTERVAL_DAY_TIME), (Object)((Object)INTERVAL_YEAR_MONTH));
        JDBC_TYPE_TO_NAME = ImmutableMap.builder().put((Object)-6, (Object)TINYINT).put((Object)5, (Object)SMALLINT).put((Object)-5, (Object)BIGINT).put((Object)4, (Object)INTEGER).put((Object)2, (Object)DECIMAL).put((Object)3, (Object)DECIMAL).put((Object)6, (Object)FLOAT).put((Object)7, (Object)REAL).put((Object)8, (Object)DOUBLE).put((Object)1, (Object)CHAR).put((Object)12, (Object)VARCHAR).put((Object)-15, (Object)CHAR).put((Object)-9, (Object)VARCHAR).put((Object)-2, (Object)BINARY).put((Object)-3, (Object)VARBINARY).put((Object)91, (Object)DATE).put((Object)92, (Object)TIME).put((Object)93, (Object)TIMESTAMP).put((Object)-7, (Object)BOOLEAN).put((Object)16, (Object)BOOLEAN).put((Object)2001, (Object)DISTINCT).put((Object)2002, (Object)STRUCTURED).put((Object)2003, (Object)ARRAY).build();
    }

    private static interface PrecScale {
        public static final int NO_NO = 1;
        public static final int YES_NO = 2;
        public static final int YES_YES = 4;
    }

    public static enum Limit {
        ZERO,
        UNDERFLOW,
        OVERFLOW;

    }
}

