/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt.helper;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.camel.tools.apt.helper.Strings;

public final class IOHelper {
    private IOHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(InputStream in, boolean skipCommentOrEmptyLines) throws IOException {
        String string;
        StringBuilder builder = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            BufferedReader reader = new BufferedReader(isr);
            while ((line = reader.readLine()) != null) {
                boolean empty = Strings.isNullOrEmpty(line);
                boolean comment = line.trim().startsWith("#");
                if (skipCommentOrEmptyLines && (empty || comment)) continue;
                builder.append(line);
                builder.append("\n");
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            IOHelper.close(isr, in);
            throw throwable;
        }
        IOHelper.close(isr, in);
        return string;
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

