/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.bom.generator;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.maven.bom.generator.DependencyMatcher;
import org.apache.camel.maven.bom.generator.DependencySet;
import org.apache.camel.maven.bom.generator.ExternalBomConflictCheck;
import org.apache.camel.maven.bom.generator.ExternalBomConflictCheckSet;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BomGeneratorMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File sourcePom;
    protected File targetPom;
    protected DependencySet dependencies;
    protected ExternalBomConflictCheckSet checkConflicts;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected List remoteRepositories;
    protected ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            DependencyManagement mng = this.project.getDependencyManagement();
            List<Dependency> filteredDependencies = this.enhance(this.filter(mng.getDependencies()));
            Set<String> externallyManagedDependencies = this.getExternallyManagedDependencies();
            this.checkConflictsWithExternalBoms(filteredDependencies, externallyManagedDependencies);
            Document pom = this.loadBasePom();
            this.overwriteDependencyManagement(pom, filteredDependencies);
            this.writePom(pom);
        }
        catch (MojoFailureException ex) {
            throw ex;
        }
        catch (MojoExecutionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Cannot generate the output BOM file", ex);
        }
    }

    private List<Dependency> enhance(List<Dependency> dependencyList) {
        for (Dependency dep : dependencyList) {
            if (!dep.getGroupId().startsWith(this.project.getGroupId()) || !this.project.getVersion().equals(dep.getVersion())) continue;
            dep.setVersion("${project.version}");
        }
        return dependencyList;
    }

    private List<Dependency> filter(List<Dependency> dependencyList) {
        ArrayList<Dependency> outDependencies = new ArrayList<Dependency>();
        DependencyMatcher inclusions = new DependencyMatcher(this.dependencies.getIncludes());
        DependencyMatcher exclusions = new DependencyMatcher(this.dependencies.getExcludes());
        for (Dependency dep : dependencyList) {
            boolean accept = inclusions.matches(dep) && !exclusions.matches(dep);
            this.getLog().debug((CharSequence)(dep + (accept ? " included in the BOM" : " excluded from BOM")));
            if (!accept) continue;
            outDependencies.add(dep);
        }
        Collections.sort(outDependencies, (d1, d2) -> (d1.getGroupId() + ":" + d1.getArtifactId()).compareTo(d2.getGroupId() + ":" + d2.getArtifactId()));
        return outDependencies;
    }

    private Document loadBasePom() throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document pom = builder.parse(this.sourcePom);
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression parentVersion = xpath.compile("/project/parent/version");
        this.setActualVersion(pom, parentVersion);
        XPathExpression projectVersion = xpath.compile("/project/version");
        this.setActualVersion(pom, projectVersion);
        return pom;
    }

    private void setActualVersion(Document pom, XPathExpression path) throws XPathExpressionException {
        Node node = (Node)path.evaluate(pom, XPathConstants.NODE);
        if (node != null && node.getTextContent() != null && node.getTextContent().trim().equals("${project.version}")) {
            node.setTextContent(this.project.getVersion());
        }
    }

    private void writePom(Document pom) throws Exception {
        String content;
        XPathExpression xpath = XPathFactory.newInstance().newXPath().compile("//text()[normalize-space(.) = '']");
        NodeList emptyNodes = (NodeList)xpath.evaluate(pom, XPathConstants.NODESET);
        for (int i = 0; i < emptyNodes.getLength(); ++i) {
            Node emptyNode = emptyNodes.item(i);
            emptyNode.getParentNode().removeChild(emptyNode);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(pom);
        this.targetPom.getParentFile().mkdirs();
        try (StringWriter out = new StringWriter();){
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            content = out.toString();
        }
        content = content.replaceFirst("-->", "-->\n");
        this.writeFileIfChanged(content, this.targetPom);
    }

    private void writeFileIfChanged(String content, File file) throws IOException {
        Throwable throwable;
        boolean write = true;
        if (file.exists()) {
            throwable = null;
            try (FileReader fr = new FileReader(file);){
                String oldContent = IOUtils.toString((Reader)fr);
                if (!content.equals(oldContent)) {
                    this.getLog().debug((CharSequence)("Writing new file " + file.getAbsolutePath()));
                    fr.close();
                }
                this.getLog().debug((CharSequence)("File " + file.getAbsolutePath() + " left unchanged"));
                write = false;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        } else {
            File parent = file.getParentFile();
            parent.mkdirs();
        }
        if (write) {
            throwable = null;
            try (FileWriter fw = new FileWriter(file);){
                IOUtils.write((String)content, (Writer)fw);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    private void overwriteDependencyManagement(Document pom, List<Dependency> dependencies) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("/project/dependencyManagement/dependencies");
        NodeList nodes = (NodeList)expr.evaluate(pom, XPathConstants.NODESET);
        if (nodes.getLength() == 0) {
            throw new IllegalStateException("No dependencies found in the dependencyManagement section of the current pom");
        }
        Node dependenciesSection = nodes.item(0);
        while (dependenciesSection.hasChildNodes()) {
            Node child = dependenciesSection.getFirstChild();
            dependenciesSection.removeChild(child);
        }
        for (Dependency dep : dependencies) {
            Element dependencyEl = pom.createElement("dependency");
            Element groupIdEl = pom.createElement("groupId");
            groupIdEl.setTextContent(dep.getGroupId());
            dependencyEl.appendChild(groupIdEl);
            Element artifactIdEl = pom.createElement("artifactId");
            artifactIdEl.setTextContent(dep.getArtifactId());
            dependencyEl.appendChild(artifactIdEl);
            Element versionEl = pom.createElement("version");
            versionEl.setTextContent(dep.getVersion());
            dependencyEl.appendChild(versionEl);
            if (!"jar".equals(dep.getType())) {
                Element typeEl = pom.createElement("type");
                typeEl.setTextContent(dep.getType());
                dependencyEl.appendChild(typeEl);
            }
            if (dep.getClassifier() != null) {
                Element classifierEl = pom.createElement("classifier");
                classifierEl.setTextContent(dep.getClassifier());
                dependencyEl.appendChild(classifierEl);
            }
            if (dep.getScope() != null && !"compile".equals(dep.getScope())) {
                Element scopeEl = pom.createElement("scope");
                scopeEl.setTextContent(dep.getScope());
                dependencyEl.appendChild(scopeEl);
            }
            if (dep.getExclusions() != null && !dep.getExclusions().isEmpty()) {
                Element exclsEl = pom.createElement("exclusions");
                for (Exclusion e : dep.getExclusions()) {
                    Element exclEl = pom.createElement("exclusion");
                    Element groupIdExEl = pom.createElement("groupId");
                    groupIdExEl.setTextContent(e.getGroupId());
                    exclEl.appendChild(groupIdExEl);
                    Element artifactIdExEl = pom.createElement("artifactId");
                    artifactIdExEl.setTextContent(e.getArtifactId());
                    exclEl.appendChild(artifactIdExEl);
                    exclsEl.appendChild(exclEl);
                }
                dependencyEl.appendChild(exclsEl);
            }
            dependenciesSection.appendChild(dependencyEl);
        }
    }

    private void checkConflictsWithExternalBoms(Collection<Dependency> dependencies, Set<String> external) throws MojoFailureException {
        TreeSet<String> errors = new TreeSet<String>();
        for (Dependency d : dependencies) {
            String key = this.comparisonKey(d);
            if (!external.contains(key)) continue;
            errors.add(key);
        }
        if (errors.size() > 0) {
            StringBuilder msg = new StringBuilder();
            msg.append("Found ").append(errors.size()).append(" conflicts between the current managed dependencies and the external BOMS:\n");
            for (String error : errors) {
                msg.append(" - ").append(error).append("\n");
            }
            throw new MojoFailureException(msg.toString());
        }
    }

    private Set<String> getExternallyManagedDependencies() throws Exception {
        HashSet<String> provided = new HashSet<String>();
        if (this.checkConflicts != null && this.checkConflicts.getBoms() != null) {
            for (ExternalBomConflictCheck check : this.checkConflicts.getBoms()) {
                Set<String> bomProvided = this.getProvidedDependencyManagement(check.getGroupId(), check.getArtifactId(), check.getVersion());
                provided.addAll(bomProvided);
            }
        }
        return provided;
    }

    private Set<String> getProvidedDependencyManagement(String groupId, String artifactId, String version) throws Exception {
        return this.getProvidedDependencyManagement(groupId, artifactId, version, new TreeSet<String>());
    }

    private Set<String> getProvidedDependencyManagement(String groupId, String artifactId, String version, Set<String> gaChecked) throws Exception {
        String ga = groupId + ":" + artifactId;
        gaChecked.add(ga);
        Artifact bom = this.resolveArtifact(groupId, artifactId, version, "pom");
        MavenProject bomProject = this.loadExternalProjectPom(bom.getFile());
        HashSet<String> provided = new HashSet<String>();
        if (bomProject.getDependencyManagement() != null && bomProject.getDependencyManagement().getDependencies() != null) {
            for (Dependency dep : bomProject.getDependencyManagement().getDependencies()) {
                if ("pom".equals(dep.getType()) && "import".equals(dep.getScope())) {
                    String subGa = dep.getGroupId() + ":" + dep.getArtifactId();
                    if (gaChecked.contains(subGa)) continue;
                    Set<String> sub = this.getProvidedDependencyManagement(dep.getGroupId(), dep.getArtifactId(), this.resolveVersion(bomProject, dep.getVersion()), gaChecked);
                    provided.addAll(sub);
                    continue;
                }
                provided.add(this.comparisonKey(dep));
            }
        }
        return provided;
    }

    private String resolveVersion(MavenProject project, String version) {
        if (version.contains("${")) {
            int start = version.indexOf("${");
            int end = version.indexOf("}");
            if (end > start) {
                String prop = version.substring(start + 2, end);
                String resolved = project.getProperties().getProperty(prop);
                if (resolved != null) {
                    version = version.substring(0, start) + resolved + version.substring(end + 1);
                }
            }
        }
        return version;
    }

    private String comparisonKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + (dependency.getType() != null ? dependency.getType() : "jar");
    }

    private Artifact resolveArtifact(String groupId, String artifactId, String version, String type) throws Exception {
        Artifact art = this.artifactFactory.createArtifact(groupId, artifactId, version, "runtime", type);
        this.artifactResolver.resolve(art, this.remoteRepositories, this.localRepository);
        return art;
    }

    private MavenProject loadExternalProjectPom(File pomFile) throws Exception {
        try (FileReader reader = new FileReader(pomFile);){
            MavenXpp3Reader mavenReader = new MavenXpp3Reader();
            Model model = mavenReader.read((Reader)reader);
            MavenProject project = new MavenProject(model);
            project.setFile(pomFile);
            MavenProject mavenProject = project;
            return mavenProject;
        }
    }
}

