/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.health;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.StaticService;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.spi.HasId;
import org.apache.camel.spi.IdAware;
import org.apache.camel.util.ObjectHelper;

public interface HealthCheckRegistry
extends CamelContextAware,
StaticService,
IdAware {
    public static final String NAME = "default-registry";
    public static final String FACTORY = "health-check/default-registry";

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public Object resolveById(String var1);

    public boolean register(Object var1);

    public boolean unregister(Object var1);

    default public Collection<String> getCheckIDs() {
        return this.stream().map(HasId::getId).collect(Collectors.toList());
    }

    default public Optional<HealthCheck> getCheck(String id) {
        return this.stream().filter(r -> ObjectHelper.equal((Object)r.getId(), (Object)id) || ObjectHelper.equal((Object)r.getId().replace("-health-check", ""), (Object)id) || ObjectHelper.equal((Object)r.getId().replace("route:", ""), (Object)id)).findFirst();
    }

    public Optional<HealthCheckRepository> getRepository(String var1);

    public static HealthCheckRegistry get(CamelContext context) {
        return context != null ? context.getCamelContextExtension().getContextPlugin(HealthCheckRegistry.class) : null;
    }

    public Stream<HealthCheck> stream();

    public void loadHealthChecks();

    public String getExcludePattern();

    public void setExcludePattern(String var1);

    public boolean isExcluded(HealthCheck var1);

    public void setExposureLevel(String var1);

    public String getExposureLevel();

    public void setInitialState(HealthCheck.State var1);

    public HealthCheck.State getInitialState();
}

