/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.attachment;

import jakarta.activation.DataHandler;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachment;
import org.apache.camel.trait.message.MessageTrait;

public final class DefaultAttachmentMessage
implements AttachmentMessage {
    private final Message delegate;

    public DefaultAttachmentMessage(Message delegate) {
        this.delegate = delegate;
    }

    private Map<String, Object> getAttachmentsMap() {
        LinkedHashMap m = (LinkedHashMap)this.delegate.getPayloadForTrait(MessageTrait.ATTACHMENTS);
        if (m == null) {
            m = new LinkedHashMap();
            this.delegate.setPayloadForTrait(MessageTrait.ATTACHMENTS, m);
        }
        return m;
    }

    public Message newInstance() {
        return new DefaultAttachmentMessage(this.delegate);
    }

    public void reset() {
        this.delegate.reset();
    }

    public String getMessageId() {
        return this.delegate.getMessageId();
    }

    public void setMessageId(String messageId) {
        this.delegate.setMessageId(messageId);
    }

    public boolean hasMessageId() {
        return this.delegate.getMessageId() != null;
    }

    public long getMessageTimestamp() {
        return this.delegate.getMessageTimestamp();
    }

    public Exchange getExchange() {
        return this.delegate.getExchange();
    }

    public Object getHeader(String name) {
        return this.delegate.getHeader(name);
    }

    public Object getHeader(String name, Object defaultValue) {
        return this.delegate.getHeader(name, defaultValue);
    }

    public Object getHeader(String name, Supplier<Object> defaultValueSupplier) {
        return this.delegate.getHeader(name, defaultValueSupplier);
    }

    public <T> T getHeader(String name, Class<T> type) {
        return (T)this.delegate.getHeader(name, type);
    }

    public <T> T getHeader(String name, Object defaultValue, Class<T> type) {
        return (T)this.delegate.getHeader(name, defaultValue, type);
    }

    public <T> T getHeader(String name, Supplier<Object> defaultValueSupplier, Class<T> type) {
        return (T)this.delegate.getHeader(name, defaultValueSupplier, type);
    }

    public void setHeader(String name, Object value) {
        this.delegate.setHeader(name, value);
    }

    public Object removeHeader(String name) {
        return this.delegate.removeHeader(name);
    }

    public boolean removeHeaders(String pattern) {
        return this.delegate.removeHeaders(pattern);
    }

    public boolean removeHeaders(String pattern, String ... excludePatterns) {
        return this.delegate.removeHeaders(pattern, excludePatterns);
    }

    public Map<String, Object> getHeaders() {
        return this.delegate.getHeaders();
    }

    public void setHeaders(Map<String, Object> headers) {
        this.delegate.setHeaders(headers);
    }

    public boolean hasHeaders() {
        return this.delegate.hasHeaders();
    }

    public Object getBody() {
        return this.delegate.getBody();
    }

    public Object getMandatoryBody() throws InvalidPayloadException {
        return this.delegate.getMandatoryBody();
    }

    public <T> T getBody(Class<T> type) {
        return (T)this.delegate.getBody(type);
    }

    public <T> T getMandatoryBody(Class<T> type) throws InvalidPayloadException {
        return (T)this.delegate.getMandatoryBody(type);
    }

    public void setBody(Object body) {
        this.delegate.setBody(body);
    }

    public <T> void setBody(Object body, Class<T> type) {
        this.delegate.setBody(body, type);
    }

    public Message copy() {
        return new DefaultAttachmentMessage(this.delegate.copy());
    }

    public void copyFrom(Message message) {
        this.delegate.copyFrom(message);
    }

    public void copyFromWithNewBody(Message message, Object newBody) {
        this.delegate.copyFromWithNewBody(message, newBody);
    }

    @Override
    public DataHandler getAttachment(String id) {
        Attachment att = (Attachment)this.getAttachmentsMap().get(id);
        if (att != null) {
            return att.getDataHandler();
        }
        return null;
    }

    @Override
    public Attachment getAttachmentObject(String id) {
        return (Attachment)this.getAttachmentsMap().get(id);
    }

    @Override
    public Set<String> getAttachmentNames() {
        return this.getAttachmentsMap().keySet();
    }

    @Override
    public void removeAttachment(String id) {
        this.getAttachmentsMap().remove(id);
    }

    @Override
    public void addAttachment(String id, DataHandler content) {
        this.getAttachmentsMap().put(id, new DefaultAttachment(content));
    }

    @Override
    public void addAttachmentObject(String id, Attachment content) {
        this.getAttachmentsMap().put(id, content);
    }

    @Override
    public Map<String, DataHandler> getAttachments() {
        LinkedHashMap answer = new LinkedHashMap();
        this.getAttachmentsMap().forEach((id, att) -> {
            Attachment a = (Attachment)att;
            answer.put(id, a.getDataHandler());
        });
        return Collections.unmodifiableMap(answer);
    }

    @Override
    public Map<String, Attachment> getAttachmentObjects() {
        LinkedHashMap answer = new LinkedHashMap();
        this.getAttachmentsMap().forEach((id, att) -> {
            Attachment a = (Attachment)att;
            answer.put(id, a);
        });
        return Collections.unmodifiableMap(answer);
    }

    @Override
    public void setAttachments(Map<String, DataHandler> attachments) {
        attachments.forEach((id, dh) -> this.getAttachmentsMap().put((String)id, new DefaultAttachment((DataHandler)dh)));
    }

    @Override
    public void setAttachmentObjects(Map<String, Attachment> attachments) {
        this.getAttachmentsMap().putAll(attachments);
    }

    @Override
    public boolean hasAttachments() {
        return this.delegate.hasTrait(MessageTrait.ATTACHMENTS);
    }

    @Override
    public void clearAttachments() {
        this.delegate.removeTrait(MessageTrait.ATTACHMENTS);
    }

    public boolean hasTrait(MessageTrait trait) {
        return this.delegate.hasTrait(trait);
    }

    public Object getPayloadForTrait(MessageTrait trait) {
        return this.delegate.getPayloadForTrait(trait);
    }

    public void setPayloadForTrait(MessageTrait trait, Object object) {
        this.delegate.setPayloadForTrait(trait, object);
    }

    public void removeTrait(MessageTrait trait) {
        this.delegate.removeTrait(trait);
    }
}

