/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.GenericBootstrap;
import org.apache.camel.component.bean.validator.HibernateValidationProviderResolver;

public final class ValidatorFactories {
    private ValidatorFactories() {
    }

    public static ValidatorFactory buildValidatorFactory(boolean osgi, boolean ignoreXml, ValidationProviderResolver validationProviderResolver, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ConstraintValidatorFactory constraintValidatorFactory) {
        ValidationProviderResolver resolvedValidationProviderResolver = ValidatorFactories.resolveValidationProviderResolver(osgi, validationProviderResolver);
        GenericBootstrap bootstrap = Validation.byDefaultProvider();
        if (resolvedValidationProviderResolver != null) {
            bootstrap.providerResolver(resolvedValidationProviderResolver);
        }
        Configuration configuration = bootstrap.configure();
        if (messageInterpolator != null) {
            configuration.messageInterpolator(messageInterpolator);
        }
        if (traversableResolver != null) {
            configuration.traversableResolver(traversableResolver);
        }
        if (constraintValidatorFactory != null) {
            configuration.constraintValidatorFactory(constraintValidatorFactory);
        }
        if (ignoreXml) {
            configuration.ignoreXmlConfiguration();
        }
        return configuration.buildValidatorFactory();
    }

    private static ValidationProviderResolver resolveValidationProviderResolver(boolean osgi, ValidationProviderResolver validationProviderResolver) {
        if (validationProviderResolver != null) {
            return validationProviderResolver;
        }
        if (osgi) {
            return new HibernateValidationProviderResolver();
        }
        return null;
    }
}

