/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.util;

import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.annotation.BindyConverter;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.KeyValuePairField;

public final class ConverterUtils {
    private ConverterUtils() {
    }

    public static char getCharDelimiter(String separator) {
        if (separator.equals("\\u0001")) {
            return '\u0001';
        }
        if (separator.equals("\\t") || separator.equals("\\u0009")) {
            return '\t';
        }
        if (separator.length() > 1) {
            return separator.charAt(separator.length() - 1);
        }
        return separator.charAt(0);
    }

    public static byte[] getByteReturn(String returnCharacter) {
        if (returnCharacter.equals("WINDOWS")) {
            return new byte[]{13, 10};
        }
        if (returnCharacter.equals("UNIX")) {
            return new byte[]{10};
        }
        if (returnCharacter.equals("MAC")) {
            return new byte[]{13};
        }
        return returnCharacter.getBytes();
    }

    public static String getStringCarriageReturn(String returnCharacter) {
        if (returnCharacter.equals("WINDOWS")) {
            return "\r\n";
        }
        if (returnCharacter.equals("UNIX")) {
            return "\n";
        }
        if (returnCharacter.equals("MAC")) {
            return "\r";
        }
        return returnCharacter;
    }

    public static FormattingOptions convert(DataField dataField, Class<?> clazz, BindyConverter converter, String locale) {
        return new FormattingOptions().forClazz(clazz).withPattern(dataField.pattern()).withLocale(locale).withTimezone(dataField.timezone()).withPrecision(dataField.precision()).withRounding(dataField.rounding()).withImpliedDecimalSeparator(dataField.impliedDecimalSeparator()).withDecimalSeparator(dataField.decimalSeparator()).withBindyConverter(converter).withGroupingSeparator(dataField.groupingSeparator());
    }

    public static FormattingOptions convert(KeyValuePairField dataField, Class<?> clazz, BindyConverter converter, String locale) {
        return new FormattingOptions().forClazz(clazz).withPattern(dataField.pattern()).withLocale(locale).withTimezone(dataField.timezone()).withPrecision(dataField.precision()).withBindyConverter(converter).withImpliedDecimalSeparator(dataField.impliedDecimalSeparator());
    }
}

