/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlueprintCamelContext
extends DefaultCamelContext {
    private static final transient Log LOG = LogFactory.getLog(BlueprintCamelContext.class);
    private boolean shouldStartContext = ObjectHelper.getSystemProperty((String)"shouldStartContext", (Boolean)Boolean.TRUE);

    public void init() throws Exception {
        this.maybeStart();
    }

    private void maybeStart() throws Exception {
        if (!this.getShouldStartContext()) {
            LOG.info((Object)"Not starting Apache Camel as property ShouldStartContext is false");
            return;
        }
        if (!this.isStarted() && !this.isStarting()) {
            LOG.info((Object)"Starting Apache Camel as property ShouldStartContext is true");
            this.start();
        } else {
            LOG.trace((Object)"Ignoring maybeStart() as Apache Camel is already started");
        }
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void setShouldStartContext(boolean shouldStartContext) {
        this.shouldStartContext = shouldStartContext;
    }

    public boolean getShouldStartContext() {
        return this.shouldStartContext;
    }
}

