/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint.handler;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.camel.ExchangePattern;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.blueprint.CamelContextFactoryBean;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.util.ObjectHelper;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.Target;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelNamespaceHandler
implements NamespaceHandler {
    private static final String CAMEL_CONTEXT = "camelContext";
    private static final String SPRING_NS = "http://camel.apache.org/schema/spring";
    private static final String BLUEPRINT_NS = "http://camel.apache.org/schema/blueprint";
    private JAXBContext jaxbContext;

    public static void renameNamespaceRecursive(Node node) {
        if (node.getNodeType() == 1) {
            Document doc = node.getOwnerDocument();
            if (((Element)node).getNamespaceURI().equals(BLUEPRINT_NS)) {
                doc.renameNode(node, SPRING_NS, node.getNodeName());
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            CamelNamespaceHandler.renameNamespaceRecursive(list.item(i));
        }
    }

    public URL getSchemaLocation(String namespace) {
        return this.getClass().getClassLoader().getResource("camel-blueprint.xsd");
    }

    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(BlueprintCamelContext.class));
    }

    public Metadata parse(Element element, ParserContext context) {
        CamelNamespaceHandler.renameNamespaceRecursive(element);
        if (element.getNodeName().equals(CAMEL_CONTEXT)) {
            Binder binder;
            String contextId = element.getAttribute("id");
            if (ObjectHelper.isEmpty((Object)contextId)) {
                contextId = CAMEL_CONTEXT;
                element.setAttribute("id", contextId);
            }
            try {
                binder = this.getJaxbContext().createBinder();
            }
            catch (JAXBException e) {
                throw new ComponentDefinitionException("Failed to create the JAXB binder : " + (Object)((Object)e), (Throwable)e);
            }
            Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
            if (!(value instanceof CamelContextFactoryBean)) {
                throw new ComponentDefinitionException("Expected an instance of " + CamelContextFactoryBean.class);
            }
            MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
            factory.setId(".camelBlueprint.passThrough." + contextId);
            factory.setObject(new PassThroughCallable<Object>(value));
            MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
            factory2.setId(".camelBlueprint.factory." + contextId);
            factory2.setFactoryComponent((Target)factory);
            factory2.setFactoryMethod("call");
            factory2.setInitMethod("init");
            factory2.setDestroyMethod("destroy");
            MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
            ctx.setId(contextId);
            ctx.setFactoryComponent((Target)factory2);
            ctx.setFactoryMethod("getContext");
            ctx.setInitMethod("init");
            ctx.setDestroyMethod("destroy");
            return ctx;
        }
        return null;
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        return null;
    }

    protected Object parseUsingJaxb(Element element, ParserContext parserContext, Binder<Node> binder) {
        try {
            return binder.unmarshal((Object)element);
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to parse JAXB element: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = this.createJaxbContext();
        }
        return this.jaxbContext;
    }

    protected JAXBContext createJaxbContext() throws JAXBException {
        StringBuilder packages = new StringBuilder();
        for (Class cl : this.getJaxbPackages()) {
            if (packages.length() > 0) {
                packages.append(":");
            }
            packages.append(cl.getName().substring(0, cl.getName().lastIndexOf(46)));
        }
        return JAXBContext.newInstance((String)packages.toString(), (ClassLoader)this.getClass().getClassLoader());
    }

    protected Set<Class> getJaxbPackages() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(CamelContextFactoryBean.class);
        classes.add(ExchangePattern.class);
        classes.add(RouteDefinition.class);
        classes.add(StreamResequencerConfig.class);
        classes.add(DataFormatsDefinition.class);
        classes.add(ExpressionDefinition.class);
        classes.add(RoundRobinLoadBalancerDefinition.class);
        return classes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PassThroughCallable<T>
    implements Callable<T> {
        private T value;

        public PassThroughCallable(T value) {
            this.value = value;
        }

        @Override
        public T call() throws Exception {
            return this.value;
        }
    }
}

