/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OsgiLanguageResolver
implements LanguageResolver {
    private static final transient Log LOG = LogFactory.getLog(OsgiLanguageResolver.class);
    private final BundleContext bundleContext;

    public OsgiLanguageResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Language resolveLanguage(String name, CamelContext context) {
        Object bean;
        block6: {
            bean = null;
            try {
                bean = context.getRegistry().lookup(name);
                if (bean != null && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found language: " + name + " in registry: " + bean));
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)("Ignored error looking up bean: " + name + ". Error: " + e));
            }
        }
        if (bean instanceof Language) {
            return (Language)bean;
        }
        Language lang = this.getLanguage(name, context);
        if (lang != null) {
            return lang;
        }
        LanguageResolver resolver = this.getLanguageResolver("default", context);
        if (resolver != null) {
            return resolver.resolveLanguage(name, context);
        }
        throw new NoSuchLanguageException(name);
    }

    protected Language getLanguage(String name, CamelContext context) {
        LOG.trace((Object)("Finding Language: " + name));
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(LanguageResolver.class.getName(), "(language=" + name + ")");
            if (refs != null && refs.length > 0) {
                LanguageResolver resolver = (LanguageResolver)this.bundleContext.getService(refs[0]);
                return resolver.resolveLanguage(name, context);
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected LanguageResolver getLanguageResolver(String name, CamelContext context) {
        LOG.trace((Object)("Finding LanguageResolver: " + name));
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(LanguageResolver.class.getName(), "(resolver=" + name + ")");
            if (refs != null && refs.length > 0) {
                LanguageResolver resolver = (LanguageResolver)this.bundleContext.getService(refs[0]);
                return resolver;
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

