/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.connector;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.catalog.connector.ConnectorDataStore;
import org.apache.camel.catalog.connector.ConnectorDto;

public class MemoryConnectorDataStore
implements ConnectorDataStore {
    private Set<ConnectorDetails> store = new CopyOnWriteArraySet<ConnectorDetails>();

    @Override
    public void addConnector(ConnectorDto dto, String connectorJson, String connectorSchemaJson, String componentSchemaJson) {
        ConnectorDetails entry = new ConnectorDetails(dto, connectorJson, connectorSchemaJson, componentSchemaJson);
        this.store.remove(entry);
        this.store.add(entry);
    }

    @Override
    public boolean hasConnector(ConnectorDto dto) {
        return this.store.contains(new ConnectorDetails(dto, null, null, null));
    }

    @Override
    public void removeConnector(ConnectorDto dto) {
        this.store.remove(new ConnectorDetails(dto, null, null, null));
    }

    @Override
    public List<ConnectorDto> findConnector(String filter, boolean latestVersionOnly) {
        ArrayList<ConnectorDto> answer = new ArrayList<ConnectorDto>();
        if (filter != null && !filter.isEmpty()) {
            filter = filter.toLowerCase(Locale.US);
            block0: for (ConnectorDetails detail : this.store) {
                String[] arr;
                ConnectorDto dto = detail.getDto();
                if (dto.getName().toLowerCase(Locale.US).contains(filter)) {
                    answer.add(dto);
                    continue;
                }
                if (dto.getDescription().toLowerCase(Locale.US).contains(filter)) {
                    answer.add(dto);
                    continue;
                }
                if (dto.getGroupId().toLowerCase(Locale.US).contains(filter)) {
                    answer.add(dto);
                    continue;
                }
                if (dto.getArtifactId().toLowerCase(Locale.US).contains(filter)) {
                    answer.add(dto);
                    continue;
                }
                if (dto.getVersion().toLowerCase(Locale.US).contains(filter)) {
                    answer.add(dto);
                    continue;
                }
                String labels = dto.getLabels();
                if (labels == null) continue;
                for (String lab : arr = labels.split(",")) {
                    if (!(lab = lab.toLowerCase(Locale.US)).contains(filter)) continue;
                    answer.add(dto);
                    continue block0;
                }
            }
        } else {
            this.store.forEach(d -> answer.add(d.getDto()));
        }
        if (latestVersionOnly && answer.size() > 1) {
            answer.sort(Comparator.comparing(ConnectorDto::getMavenGav));
            ArrayList<ConnectorDto> unique = new ArrayList<ConnectorDto>();
            ConnectorDto prev = null;
            for (ConnectorDto dto : answer) {
                if (prev == null || prev.getGroupId().equals(dto.getGroupId()) && prev.getArtifactId().equals(dto.getArtifactId())) {
                    prev = dto;
                    continue;
                }
                unique.add(prev);
                prev = dto;
            }
            if (prev != null) {
                unique.add(prev);
            }
            return unique;
        }
        return answer;
    }

    @Override
    public String connectorJSon(ConnectorDto dto) {
        return ((ConnectorDetails)this.store.stream().filter(d -> d.getDto().equals(dto)).findFirst().orElse(null)).getConnectorJson();
    }

    @Override
    public String connectorSchemaJSon(ConnectorDto dto) {
        return ((ConnectorDetails)this.store.stream().filter(d -> d.getDto().equals(dto)).findFirst().orElse(null)).getConnectorSchemaJson();
    }

    @Override
    public String componentSchemaJSon(ConnectorDto dto) {
        return ((ConnectorDetails)this.store.stream().filter(d -> d.getDto().equals(dto)).findFirst().orElse(null)).getComponentSchemaJson();
    }

    private static final class ConnectorDetails {
        private ConnectorDto dto;
        private String connectorJson;
        private String connectorSchemaJson;
        private String componentSchemaJson;

        ConnectorDetails(ConnectorDto dto, String connectorJson, String connectorSchemaJson, String componentSchemaJson) {
            this.dto = dto;
            this.connectorJson = connectorJson;
            this.connectorSchemaJson = connectorSchemaJson;
            this.componentSchemaJson = componentSchemaJson;
        }

        ConnectorDto getDto() {
            return this.dto;
        }

        String getConnectorJson() {
            return this.connectorJson;
        }

        String getConnectorSchemaJson() {
            return this.connectorSchemaJson;
        }

        String getComponentSchemaJson() {
            return this.componentSchemaJson;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectorDetails entry = (ConnectorDetails)o;
            return this.dto.equals(entry.dto);
        }

        public int hashCode() {
            return this.dto.hashCode();
        }
    }
}

