/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.catalog.ConfigurationPropertiesValidationResult;
import org.apache.camel.catalog.EndpointValidationResult;
import org.apache.camel.catalog.JSonSchemaResolver;
import org.apache.camel.catalog.Kind;
import org.apache.camel.catalog.LanguageValidationResult;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.SuggestionStrategy;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.model.ReleaseModel;

public interface CamelCatalog {
    public JSonSchemaResolver getJSonSchemaResolver();

    public void setJSonSchemaResolver(JSonSchemaResolver var1);

    public void setRuntimeProvider(RuntimeProvider var1);

    public RuntimeProvider getRuntimeProvider();

    public void enableCache();

    public boolean isCaching();

    public void setSuggestionStrategy(SuggestionStrategy var1);

    public SuggestionStrategy getSuggestionStrategy();

    public void setVersionManager(VersionManager var1);

    public VersionManager getVersionManager();

    public void addComponent(String var1, String var2);

    public void addComponent(String var1, String var2, String var3);

    public void addDataFormat(String var1, String var2);

    public void addDataFormat(String var1, String var2, String var3);

    public String getCatalogVersion();

    public boolean loadVersion(String var1);

    public String getLoadedVersion();

    public String getRuntimeProviderLoadedVersion();

    public boolean loadRuntimeProviderVersion(String var1, String var2, String var3);

    public List<String> findComponentNames();

    public List<String> findDataFormatNames();

    public List<String> findLanguageNames();

    public List<String> findModelNames();

    public List<String> findOtherNames();

    default public List<String> findNames(Kind kind) {
        switch (kind) {
            case component: {
                return this.findComponentNames();
            }
            case dataformat: {
                return this.findDataFormatNames();
            }
            case language: {
                return this.findLanguageNames();
            }
            case other: {
                return this.findOtherNames();
            }
            case eip: {
                return this.findModelNames();
            }
        }
        throw new IllegalArgumentException("Unexpected kind " + String.valueOf((Object)kind));
    }

    public List<String> findComponentNames(String var1);

    public List<String> findDataFormatNames(String var1);

    public List<String> findLanguageNames(String var1);

    public List<String> findModelNames(String var1);

    public List<String> findOtherNames(String var1);

    public String componentJSonSchema(String var1);

    public String dataFormatJSonSchema(String var1);

    public String languageJSonSchema(String var1);

    public String otherJSonSchema(String var1);

    public String modelJSonSchema(String var1);

    public Set<String> findComponentLabels();

    public Set<String> findDataFormatLabels();

    public Set<String> findLanguageLabels();

    public Set<String> findModelLabels();

    public Set<String> findOtherLabels();

    public String springSchemaAsXml();

    public String mainJsonSchema();

    public Map<String, String> endpointProperties(String var1) throws URISyntaxException;

    public Map<String, String> endpointLenientProperties(String var1) throws URISyntaxException;

    public boolean validateTimePattern(String var1);

    public EndpointValidationResult validateEndpointProperties(String var1);

    public EndpointValidationResult validateEndpointProperties(String var1, boolean var2);

    public EndpointValidationResult validateEndpointProperties(String var1, boolean var2, boolean var3, boolean var4);

    public LanguageValidationResult validateLanguagePredicate(ClassLoader var1, String var2, String var3);

    public LanguageValidationResult validateLanguageExpression(ClassLoader var1, String var2, String var3);

    public ConfigurationPropertiesValidationResult validateConfigurationProperty(String var1);

    public String endpointComponentName(String var1);

    public String asEndpointUri(String var1, Map<String, String> var2, boolean var3) throws URISyntaxException;

    public String asEndpointUriXml(String var1, Map<String, String> var2, boolean var3) throws URISyntaxException;

    public String listComponentsAsJson();

    public String listDataFormatsAsJson();

    public String listLanguagesAsJson();

    public String listModelsAsJson();

    public String listOthersAsJson();

    public String summaryAsJson();

    public ComponentModel componentModel(String var1);

    public DataFormatModel dataFormatModel(String var1);

    public LanguageModel languageModel(String var1);

    public OtherModel otherModel(String var1);

    public EipModel eipModel(String var1);

    public MainModel mainModel();

    default public BaseModel<?> model(Kind kind, String name) {
        switch (kind) {
            case component: {
                return this.componentModel(name);
            }
            case dataformat: {
                return this.dataFormatModel(name);
            }
            case language: {
                return this.languageModel(name);
            }
            case other: {
                return this.otherModel(name);
            }
            case eip: {
                return this.eipModel(name);
            }
        }
        throw new IllegalArgumentException("Unexpected kind " + String.valueOf((Object)kind));
    }

    public ArtifactModel<?> modelFromMavenGAV(String var1, String var2, String var3);

    public InputStream loadResource(String var1, String var2);

    public List<ReleaseModel> camelReleases();

    public List<ReleaseModel> camelQuarkusReleases();
}

