/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.apache.camel.CamelContext;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.util.ObjectHelper;

public final class RoutesXml {
    private RoutesXml() {
    }

    public static RoutesDefinition loadRoutesFromXML(ModelCamelContext camelContext, String xml) throws JAXBException {
        return (RoutesDefinition)ModelHelper.createModelFromXml((CamelContext)camelContext, (String)xml, RoutesDefinition.class);
    }

    public static RoutesDefinition loadRoutesFromClasspath(ModelCamelContext camelContext, String uri) throws JAXBException {
        InputStream stream = ObjectHelper.loadResourceAsStream((String)uri);
        ObjectHelper.notNull((Object)stream, (String)("Could not find resource '" + uri + "' on the ClassLoader"));
        return (RoutesDefinition)ModelHelper.createModelFromXml((CamelContext)camelContext, (InputStream)stream, RoutesDefinition.class);
    }

    public static RoutesDefinition loadRoutesFromURL(ModelCamelContext camelContext, URL url) throws JAXBException, IOException {
        ObjectHelper.notNull((Object)url, (String)"url");
        return (RoutesDefinition)ModelHelper.createModelFromXml((CamelContext)camelContext, (InputStream)url.openStream(), RoutesDefinition.class);
    }

    public static RoutesDefinition loadRoutesFromURL(ModelCamelContext camelContext, String url) throws IOException, JAXBException {
        return RoutesXml.loadRoutesFromURL(camelContext, new URL(url));
    }

    public static RoutesDefinition loadRoutesFromFile(ModelCamelContext camelContext, File file) throws JAXBException, FileNotFoundException {
        ObjectHelper.notNull((Object)file, (String)"file");
        return (RoutesDefinition)ModelHelper.createModelFromXml((CamelContext)camelContext, (InputStream)new FileInputStream(file), RoutesDefinition.class);
    }

    public static RoutesDefinition loadRoutesFromFile(ModelCamelContext camelContext, String fileName) throws JAXBException, FileNotFoundException {
        return RoutesXml.loadRoutesFromFile(camelContext, new File(fileName));
    }
}

