/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.camel.cdi.AnyLiteral;
import org.apache.camel.cdi.DefaultLiteral;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.util.ObjectHelper;

@Vetoed
final class CdiSpiHelper {
    private CdiSpiHelper() {
    }

    static <T extends Annotation> T getQualifierByType(InjectionPoint ip, Class<T> type) {
        return (T)((Annotation)CdiSpiHelper.getFirstElementOfType(ip.getQualifiers(), type));
    }

    static <E, T extends E> T getFirstElementOfType(Collection<E> collection, Class<T> type) {
        for (E item : collection) {
            if (item == null || !type.isAssignableFrom(item.getClass())) continue;
            return (T)ObjectHelper.cast(type, item);
        }
        return null;
    }

    @SafeVarargs
    static <T> Set<T> excludeElementOfTypes(Set<T> annotations, Class<? extends T> ... exclusions) {
        HashSet<T> set = new HashSet<T>();
        for (T annotation : annotations) {
            boolean exclude = false;
            for (Class<T> clazz : exclusions) {
                if (!clazz.isAssignableFrom(annotation.getClass())) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            set.add(annotation);
        }
        return set;
    }

    static Class<?> getRawType(Type type) {
        Class<?> rawType;
        if (type instanceof Class) {
            return (Class)Class.class.cast(type);
        }
        if (type instanceof ParameterizedType) {
            return CdiSpiHelper.getRawType(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType());
        }
        if (type instanceof TypeVariable) {
            return CdiSpiHelper.getBound(((TypeVariable)TypeVariable.class.cast(type)).getBounds());
        }
        if (type instanceof WildcardType) {
            return CdiSpiHelper.getBound(((WildcardType)WildcardType.class.cast(type)).getUpperBounds());
        }
        if (type instanceof GenericArrayType && (rawType = CdiSpiHelper.getRawType(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType())) != null) {
            return Array.newInstance(rawType, 0).getClass();
        }
        throw new UnsupportedOperationException("Unable to retrieve raw type for [" + type + "]");
    }

    private static Class<?> getBound(Type[] bounds) {
        if (bounds.length == 0) {
            return Object.class;
        }
        return CdiSpiHelper.getRawType(bounds[0]);
    }

    @SafeVarargs
    static boolean hasAnnotation(AnnotatedType<?> type, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (!CdiSpiHelper.hasAnnotation(type, annotation)) continue;
            return true;
        }
        return false;
    }

    static boolean hasAnnotation(AnnotatedType<?> type, Class<? extends Annotation> annotation) {
        if (type.isAnnotationPresent(annotation)) {
            return true;
        }
        for (AnnotatedMethod method : type.getMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            return true;
        }
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (!constructor.isAnnotationPresent(annotation)) continue;
            return true;
        }
        for (AnnotatedField field : type.getFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    static Set<Annotation> getQualifiers(Annotated annotated, BeanManager manager) {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : annotated.getAnnotations()) {
            if (!manager.isQualifier(annotation.annotationType())) continue;
            qualifiers.add(annotation);
        }
        if (qualifiers.isEmpty()) {
            qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
        }
        qualifiers.add((Annotation)AnyLiteral.INSTANCE);
        return qualifiers;
    }
}

