/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

public class ErrorHandlerBuilderRef
extends ErrorHandlerBuilderSupport {
    private final String ref;
    private boolean supportTransacted;

    public ErrorHandlerBuilderRef(String ref) {
        this.ref = ref;
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        ErrorHandlerBuilder handler = this.lookupErrorHandler(routeContext);
        return ErrorHandlerReifier.reifier(handler).createErrorHandler(routeContext, processor);
    }

    @Override
    public boolean supportTransacted() {
        return this.supportTransacted;
    }

    @Override
    public ErrorHandlerBuilder cloneBuilder() {
        ErrorHandlerBuilderRef answer = new ErrorHandlerBuilderRef(this.ref);
        this.cloneBuilder(answer);
        return answer;
    }

    protected void cloneBuilder(ErrorHandlerBuilderRef other) {
        super.cloneBuilder(other);
        other.supportTransacted = this.supportTransacted;
    }

    public String getRef() {
        return this.ref;
    }

    private ErrorHandlerBuilder lookupErrorHandler(RouteContext routeContext) {
        ErrorHandlerBuilder handler = (ErrorHandlerBuilder)ErrorHandlerReifier.lookupErrorHandlerFactory(routeContext, this.getRef());
        ObjectHelper.notNull((Object)handler, (String)("error handler '" + this.ref + "'"));
        this.supportTransacted = handler.supportTransacted();
        routeContext.addErrorHandlerFactoryReference((ErrorHandlerFactory)this, (ErrorHandlerFactory)handler);
        return handler;
    }

    public String toString() {
        return "ErrorHandlerBuilderRef[" + this.ref + "]";
    }
}

