/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.processor.errorhandler.ExceptionPolicy;
import org.apache.camel.processor.errorhandler.ExceptionPolicyKey;
import org.apache.camel.processor.errorhandler.ExceptionPolicyStrategy;
import org.apache.camel.processor.errorhandler.RedeliveryErrorHandler;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

public abstract class ErrorHandlerBuilderSupport
implements ErrorHandlerBuilder {
    private ExceptionPolicyStrategy exceptionPolicyStrategy;

    protected void cloneBuilder(ErrorHandlerBuilderSupport other) {
        other.exceptionPolicyStrategy = this.exceptionPolicyStrategy;
    }

    public void configure(RouteContext routeContext, ErrorHandler handler) {
        if (handler instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport handlerSupport = (ErrorHandlerSupport)handler;
            Set list = routeContext.getErrorHandlers((ErrorHandlerFactory)this);
            for (NamedNode exception : list) {
                ErrorHandlerBuilderSupport.addExceptionPolicy(handlerSupport, routeContext, (OnExceptionDefinition)exception);
            }
        }
        if (handler instanceof RedeliveryErrorHandler) {
            boolean original;
            RedeliveryErrorHandler reh = (RedeliveryErrorHandler)handler;
            boolean bl = original = reh.isUseOriginalMessagePolicy() || reh.isUseOriginalBodyPolicy();
            if (original) {
                if (reh.isUseOriginalMessagePolicy() && reh.isUseOriginalBodyPolicy()) {
                    throw new IllegalArgumentException("Cannot set both useOriginalMessage and useOriginalBody on the error handler");
                }
                routeContext.setAllowUseOriginalMessage(Boolean.valueOf(true));
            }
        }
    }

    public static void addExceptionPolicy(ErrorHandlerSupport handlerSupport, RouteContext routeContext, OnExceptionDefinition exceptionType) {
        if (routeContext != null) {
            Processor errorHandler = routeContext.getOnException(exceptionType.getId());
            handlerSupport.addErrorHandler(errorHandler);
            if (ObjectHelper.isNotEmpty(exceptionType.getExceptions())) {
                List<Class<? extends Throwable>> list = ErrorHandlerBuilderSupport.createExceptionClasses(exceptionType, routeContext.getCamelContext().getClassResolver());
                for (Class<? extends Throwable> clazz : list) {
                    RouteDefinition route;
                    String routeId = null;
                    if (exceptionType.isRouteScoped() && (route = ProcessorDefinitionHelper.getRoute(exceptionType)) != null) {
                        routeId = route.getId();
                    }
                    ExpressionDefinition when = exceptionType.getOnWhen() != null ? exceptionType.getOnWhen().getExpression() : null;
                    ExceptionPolicyKey key = new ExceptionPolicyKey(routeId, clazz, (Predicate)when);
                    ExceptionPolicy policy = ErrorHandlerBuilderSupport.toExceptionPolicy(exceptionType, routeContext);
                    handlerSupport.addExceptionPolicy(key, policy);
                }
            }
        }
    }

    protected static ExceptionPolicy toExceptionPolicy(OnExceptionDefinition exceptionType, RouteContext routeContext) {
        return ErrorHandlerReifier.createExceptionPolicy(exceptionType, routeContext);
    }

    protected static List<Class<? extends Throwable>> createExceptionClasses(OnExceptionDefinition exceptionType, ClassResolver resolver) {
        List<String> list = exceptionType.getExceptions();
        ArrayList<Class<? extends Throwable>> answer = new ArrayList<Class<? extends Throwable>>(list.size());
        for (String name : list) {
            try {
                Class type = resolver.resolveMandatoryClass(name, Throwable.class);
                answer.add(type);
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return answer;
    }

    public ErrorHandlerBuilderSupport exceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.setExceptionPolicyStrategy(exceptionPolicyStrategy);
        return this;
    }

    public ExceptionPolicyStrategy getExceptionPolicyStrategy() {
        return this.exceptionPolicyStrategy;
    }

    public void setExceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        ObjectHelper.notNull((Object)exceptionPolicyStrategy, (String)"ExceptionPolicyStrategy");
        this.exceptionPolicyStrategy = exceptionPolicyStrategy;
    }
}

