/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionClauseSupport;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.builder.Namespaces;

public class ExpressionClause<T>
implements Expression,
Predicate {
    private ExpressionClauseSupport<T> delegate;

    public ExpressionClause(T result) {
        this.delegate = new ExpressionClauseSupport<T>(result);
    }

    public T expression(Expression expression) {
        return this.delegate.expression(expression);
    }

    public T constant(Object value) {
        return this.delegate.constant(value);
    }

    public T exchange() {
        return this.delegate.exchange();
    }

    public T exchange(final Function<Exchange, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange);
            }
        });
    }

    public T message() {
        return this.inMessage();
    }

    public T message(Function<Message, Object> function) {
        return this.inMessage(function);
    }

    public T inMessage() {
        return this.delegate.inMessage();
    }

    public T inMessage(final Function<Message, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn());
            }
        });
    }

    public T body() {
        return this.delegate.body();
    }

    public T body(final Function<Object, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody());
            }
        });
    }

    @Deprecated
    public T body(final Supplier<Object> supplier) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return supplier.get();
            }
        });
    }

    public T body(final BiFunction<Object, Map<String, Object>, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(), exchange.getIn().getHeaders());
            }
        });
    }

    public T body(Class<?> expectedType) {
        return this.delegate.body(expectedType);
    }

    public <B> T body(final Class<B> expectedType, final Function<B, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(expectedType));
            }
        });
    }

    public <B> T body(final Class<B> expectedType, final BiFunction<B, Map<String, Object>, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(expectedType), exchange.getIn().getHeaders());
            }
        });
    }

    public T header(String name) {
        return this.delegate.header(name);
    }

    public T headers() {
        return this.delegate.headers();
    }

    public T exchangeProperty(String name) {
        return this.delegate.exchangeProperty(name);
    }

    public T exchangeProperties() {
        return this.delegate.exchangeProperties();
    }

    public T method(String bean) {
        return this.delegate.method(bean);
    }

    public T method(Object instance) {
        return this.delegate.method(instance);
    }

    public T method(Class<?> beanType) {
        return this.delegate.method(beanType);
    }

    public T method(String bean, String method) {
        return this.delegate.method(bean, method);
    }

    public T method(Object instance, String method) {
        return this.delegate.method(instance, method);
    }

    public T method(Class<?> beanType, String method) {
        return this.delegate.method(beanType, method);
    }

    public T groovy(String text) {
        return this.delegate.groovy(text);
    }

    public T jsonpath(String text) {
        return this.delegate.jsonpath(text);
    }

    public T jsonpath(String text, boolean suppressExceptions) {
        return this.delegate.jsonpath(text, suppressExceptions);
    }

    public T jsonpath(String text, Class<?> resultType) {
        return this.delegate.jsonpath(text, resultType);
    }

    public T jsonpath(String text, boolean suppressExceptions, Class<?> resultType) {
        return this.delegate.jsonpath(text, suppressExceptions, resultType);
    }

    public T jsonpath(String text, boolean suppressExceptions, Class<?> resultType, String headerName) {
        return this.delegate.jsonpath(text, suppressExceptions, true, resultType, headerName);
    }

    public T jsonpathWriteAsString(String text) {
        return this.delegate.jsonpathWriteAsString(text);
    }

    public T jsonpathWriteAsString(String text, boolean suppressExceptions) {
        return this.delegate.jsonpathWriteAsString(text, suppressExceptions);
    }

    public T jsonpathWriteAsString(String text, boolean suppressExceptions, String headerName) {
        return this.delegate.jsonpathWriteAsString(text, suppressExceptions, true, headerName);
    }

    public T ognl(String text) {
        return this.delegate.ognl(text);
    }

    public T mvel(String text) {
        return this.delegate.mvel(text);
    }

    public T ref(String ref) {
        return this.delegate.ref(ref);
    }

    public T spel(String text) {
        return this.delegate.spel(text);
    }

    public T simple(String text) {
        return this.delegate.simple(text);
    }

    public T simple(String text, Class<?> resultType) {
        return this.delegate.simple(text, resultType);
    }

    public T tokenize(String token) {
        return this.delegate.tokenize(token);
    }

    public T tokenize(String token, boolean regex) {
        return this.tokenize(token, regex, false);
    }

    public T tokenize(String token, boolean regex, boolean skipFirst) {
        return this.delegate.tokenize(token, null, regex, skipFirst);
    }

    public T tokenize(String token, boolean regex, int group) {
        return this.tokenize(token, regex, group, false);
    }

    public T tokenize(String token, boolean regex, String group) {
        return this.tokenize(token, regex, group, false);
    }

    public T tokenize(String token, boolean regex, int group, boolean skipFirst) {
        return this.delegate.tokenize(token, null, regex, group, skipFirst);
    }

    public T tokenize(String token, boolean regex, String group, boolean skipFirst) {
        return this.delegate.tokenize(token, null, regex, group, skipFirst);
    }

    public T tokenize(String token, boolean regex, int group, String groupDelimiter, boolean skipFirst) {
        return this.delegate.tokenize(token, null, regex, "" + group, groupDelimiter, skipFirst);
    }

    public T tokenize(String token, int group) {
        return this.delegate.tokenize(token, group);
    }

    public T tokenize(String token, int group, boolean skipFirst) {
        return this.delegate.tokenize(token, group, skipFirst);
    }

    public T tokenize(String token, String headerName) {
        return this.delegate.tokenize(token, headerName);
    }

    public T tokenize(String token, String headerName, boolean regex) {
        return this.delegate.tokenize(token, headerName, regex);
    }

    public T tokenizePair(String startToken, String endToken) {
        return this.tokenizePair(startToken, endToken, false);
    }

    public T tokenizePair(String startToken, String endToken, boolean includeTokens) {
        return this.delegate.tokenizePair(startToken, endToken, includeTokens);
    }

    public T tokenizeXML(String tagName) {
        return this.tokenizeXML(tagName, null);
    }

    public T tokenizeXML(String tagName, int group) {
        return this.tokenizeXML(tagName, null, group);
    }

    public T tokenizeXML(String tagName, String inheritNamespaceTagName) {
        return this.tokenizeXML(tagName, inheritNamespaceTagName, 0);
    }

    public T tokenizeXML(String tagName, String inheritNamespaceTagName, int group) {
        return this.delegate.tokenizeXMLPair(tagName, inheritNamespaceTagName, group);
    }

    public T xtokenize(String path, Namespaces namespaces) {
        return this.xtokenize(path, 'i', namespaces);
    }

    public T xtokenize(String path, char mode, Namespaces namespaces) {
        return this.xtokenize(path, mode, namespaces, 0);
    }

    public T xtokenize(String path, char mode, Namespaces namespaces, int group) {
        return this.delegate.xtokenize(path, mode, namespaces, group);
    }

    public T xpath(String text) {
        return this.delegate.xpath(text);
    }

    public T xpath(String text, String headerName) {
        return this.delegate.xpath(text, headerName);
    }

    public T xpath(String text, Class<?> resultType) {
        return this.delegate.xpath(text, resultType);
    }

    public T xpath(String text, Class<?> resultType, String headerName) {
        return this.delegate.xpath(text, resultType, headerName);
    }

    public T xpath(String text, Class<?> resultType, Namespaces namespaces) {
        return this.delegate.xpath(text, resultType, namespaces);
    }

    public T xpath(String text, Class<?> resultType, Namespaces namespaces, String headerName) {
        return this.delegate.xpath(text, resultType, namespaces, headerName);
    }

    public T xpath(String text, Class<?> resultType, Map<String, String> namespaces) {
        return this.delegate.xpath(text, resultType, namespaces);
    }

    public T xpath(String text, Namespaces namespaces) {
        return this.delegate.xpath(text, namespaces);
    }

    public T xpath(String text, Map<String, String> namespaces) {
        return this.delegate.xpath(text, namespaces);
    }

    public T xquery(String text) {
        return this.delegate.xquery(text);
    }

    public T xquery(String text, String headerName) {
        return this.delegate.xquery(text, headerName);
    }

    public T xquery(String text, Class<?> resultType) {
        return this.delegate.xquery(text, resultType);
    }

    public T xquery(String text, Class<?> resultType, String headerName) {
        return this.delegate.xquery(text, resultType, headerName);
    }

    public T xquery(String text, Class<?> resultType, Namespaces namespaces) {
        return this.delegate.xquery(text, resultType, namespaces);
    }

    public T xquery(String text, Class<?> resultType, Namespaces namespaces, String headerName) {
        return this.delegate.xquery(text, resultType, namespaces, headerName);
    }

    public T xquery(String text, Class<?> resultType, Map<String, String> namespaces) {
        return this.delegate.xquery(text, resultType, namespaces);
    }

    public T xquery(String text, Namespaces namespaces) {
        return this.delegate.xquery(text, namespaces);
    }

    public T xquery(String text, Map<String, String> namespaces) {
        return this.delegate.xquery(text, namespaces);
    }

    public T language(String language, String expression) {
        return this.delegate.language(language, expression);
    }

    public Expression getExpressionValue() {
        return this.delegate.getExpressionValue();
    }

    public ExpressionFactory getExpressionType() {
        return this.delegate.getExpressionType();
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.getExpressionValue() != null) {
            return (T)this.getExpressionValue().evaluate(exchange, type);
        }
        Expression exp = this.delegate.getExpressionType().createExpression(exchange.getContext());
        return (T)exp.evaluate(exchange, type);
    }

    public boolean matches(Exchange exchange) {
        if (this.getExpressionValue() != null) {
            return new ExpressionToPredicateAdapter(this.getExpressionValue()).matches(exchange);
        }
        Expression exp = this.delegate.getExpressionType().createExpression(exchange.getContext());
        return new ExpressionToPredicateAdapter(exp).matches(exchange);
    }
}

