/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.builder.AggregationStrategyClause;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.PredicateClause;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.OptimisticLockRetryPolicyDefinition;
import org.apache.camel.model.OutputNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="aggregate")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AggregateDefinition
extends ProcessorDefinition<AggregateDefinition>
implements OutputNode,
ExecutorServiceAwareDefinition<AggregateDefinition> {
    @XmlElement(name="correlationExpression", required=true)
    private ExpressionSubElementDefinition correlationExpression;
    @XmlElement(name="completionPredicate")
    @AsPredicate
    private ExpressionSubElementDefinition completionPredicate;
    @XmlElement(name="completionTimeoutExpression")
    private ExpressionSubElementDefinition completionTimeoutExpression;
    @XmlElement(name="completionSizeExpression")
    private ExpressionSubElementDefinition completionSizeExpression;
    @XmlElement(name="optimisticLockRetryPolicy")
    private OptimisticLockRetryPolicyDefinition optimisticLockRetryPolicyDefinition;
    @XmlTransient
    private ExpressionDefinition expression;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlTransient
    private ScheduledExecutorService timeoutCheckerExecutorService;
    @XmlTransient
    private AggregationRepository aggregationRepository;
    @XmlTransient
    private OptimisticLockRetryPolicy optimisticLockRetryPolicy;
    @XmlAttribute
    private Boolean parallelProcessing;
    @XmlAttribute
    private Boolean optimisticLocking;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private String timeoutCheckerExecutorServiceRef;
    @XmlAttribute
    private String aggregationRepositoryRef;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private String strategyMethodName;
    @XmlAttribute
    private Boolean strategyMethodAllowNull;
    @XmlAttribute
    private Integer completionSize;
    @XmlAttribute
    private Long completionInterval;
    @XmlAttribute
    private Long completionTimeout;
    @XmlAttribute
    @Metadata(defaultValue="1000")
    private Long completionTimeoutCheckerInterval = 1000L;
    @XmlAttribute
    private Boolean completionFromBatchConsumer;
    @XmlAttribute
    private Boolean completionOnNewCorrelationGroup;
    @XmlAttribute
    private Boolean eagerCheckCompletion;
    @XmlAttribute
    private Boolean ignoreInvalidCorrelationKeys;
    @XmlAttribute
    private Integer closeCorrelationKeyOnCompletion;
    @XmlAttribute
    private Boolean discardOnCompletionTimeout;
    @XmlAttribute
    private Boolean discardOnAggregationFailure;
    @XmlAttribute
    private Boolean forceCompletionOnStop;
    @XmlAttribute
    private Boolean completeAllOnStop;
    @XmlTransient
    private AggregateController aggregateController;
    @XmlAttribute
    private String aggregateControllerRef;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();

    public AggregateDefinition() {
    }

    public AggregateDefinition(@AsPredicate Predicate predicate) {
        this(ExpressionNodeHelper.toExpressionDefinition(predicate));
    }

    public AggregateDefinition(Expression expression) {
        this(ExpressionNodeHelper.toExpressionDefinition(expression));
    }

    public AggregateDefinition(ExpressionDefinition correlationExpression) {
        this.setExpression(correlationExpression);
        ExpressionSubElementDefinition cor = new ExpressionSubElementDefinition();
        cor.setExpressionType(correlationExpression);
        this.setCorrelationExpression(cor);
    }

    public AggregateDefinition(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        this(correlationExpression);
        this.aggregationStrategy = aggregationStrategy;
    }

    public String toString() {
        return "Aggregate[" + this.description() + " -> " + this.getOutputs() + "]";
    }

    protected String description() {
        return this.getExpression() != null ? this.getExpression().getLabel() : "";
    }

    public String getShortName() {
        return "aggregate";
    }

    @Override
    public String getLabel() {
        return "aggregate[" + this.description() + "]";
    }

    @Override
    public void configureChild(ProcessorDefinition<?> output) {
        ExpressionFactory model;
        ExpressionClause clause;
        ExpressionDefinition exp = this.getExpression();
        if (this.getExpression() != null && this.getExpression().getExpressionValue() != null) {
            exp = this.getExpression().getExpressionValue();
        }
        if (exp instanceof ExpressionClause && (clause = (ExpressionClause)((Object)exp)).getExpressionType() != null && (model = clause.getExpressionType()) instanceof ExpressionDefinition) {
            this.correlationExpression = new ExpressionSubElementDefinition();
            this.correlationExpression.setExpressionType((ExpressionDefinition)model);
        }
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getAggregationStrategyRef() {
        return this.strategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.strategyRef = aggregationStrategyRef;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public String getAggregationStrategyMethodName() {
        return this.strategyMethodName;
    }

    public void setAggregationStrategyMethodName(String strategyMethodName) {
        this.strategyMethodName = strategyMethodName;
    }

    public Boolean getStrategyMethodAllowNull() {
        return this.strategyMethodAllowNull;
    }

    public String getStrategyMethodName() {
        return this.strategyMethodName;
    }

    public void setStrategyMethodName(String strategyMethodName) {
        this.strategyMethodName = strategyMethodName;
    }

    public void setStrategyMethodAllowNull(Boolean strategyMethodAllowNull) {
        this.strategyMethodAllowNull = strategyMethodAllowNull;
    }

    public void setCorrelationExpression(ExpressionSubElementDefinition correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public ExpressionSubElementDefinition getCorrelationExpression() {
        return this.correlationExpression;
    }

    public Integer getCompletionSize() {
        return this.completionSize;
    }

    public void setCompletionSize(Integer completionSize) {
        this.completionSize = completionSize;
    }

    public OptimisticLockRetryPolicyDefinition getOptimisticLockRetryPolicyDefinition() {
        return this.optimisticLockRetryPolicyDefinition;
    }

    public void setOptimisticLockRetryPolicyDefinition(OptimisticLockRetryPolicyDefinition optimisticLockRetryPolicyDefinition) {
        this.optimisticLockRetryPolicyDefinition = optimisticLockRetryPolicyDefinition;
    }

    public OptimisticLockRetryPolicy getOptimisticLockRetryPolicy() {
        return this.optimisticLockRetryPolicy;
    }

    public void setOptimisticLockRetryPolicy(OptimisticLockRetryPolicy optimisticLockRetryPolicy) {
        this.optimisticLockRetryPolicy = optimisticLockRetryPolicy;
    }

    public Long getCompletionInterval() {
        return this.completionInterval;
    }

    public void setCompletionInterval(Long completionInterval) {
        this.completionInterval = completionInterval;
    }

    public Long getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setCompletionTimeout(Long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public Long getCompletionTimeoutCheckerInterval() {
        return this.completionTimeoutCheckerInterval;
    }

    public void setCompletionTimeoutCheckerInterval(Long completionTimeoutCheckerInterval) {
        this.completionTimeoutCheckerInterval = completionTimeoutCheckerInterval;
    }

    public ExpressionSubElementDefinition getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(ExpressionSubElementDefinition completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public ExpressionSubElementDefinition getCompletionTimeoutExpression() {
        return this.completionTimeoutExpression;
    }

    public void setCompletionTimeoutExpression(ExpressionSubElementDefinition completionTimeoutExpression) {
        this.completionTimeoutExpression = completionTimeoutExpression;
    }

    public ExpressionSubElementDefinition getCompletionSizeExpression() {
        return this.completionSizeExpression;
    }

    public void setCompletionSizeExpression(ExpressionSubElementDefinition completionSizeExpression) {
        this.completionSizeExpression = completionSizeExpression;
    }

    public Boolean getCompletionFromBatchConsumer() {
        return this.completionFromBatchConsumer;
    }

    public void setCompletionFromBatchConsumer(Boolean completionFromBatchConsumer) {
        this.completionFromBatchConsumer = completionFromBatchConsumer;
    }

    public Boolean getCompletionOnNewCorrelationGroup() {
        return this.completionOnNewCorrelationGroup;
    }

    public void setCompletionOnNewCorrelationGroup(Boolean completionOnNewCorrelationGroup) {
        this.completionOnNewCorrelationGroup = completionOnNewCorrelationGroup;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Boolean getOptimisticLocking() {
        return this.optimisticLocking;
    }

    public void setOptimisticLocking(boolean optimisticLocking) {
        this.optimisticLocking = optimisticLocking;
    }

    public Boolean getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean getEagerCheckCompletion() {
        return this.eagerCheckCompletion;
    }

    public void setEagerCheckCompletion(Boolean eagerCheckCompletion) {
        this.eagerCheckCompletion = eagerCheckCompletion;
    }

    public Boolean getIgnoreInvalidCorrelationKeys() {
        return this.ignoreInvalidCorrelationKeys;
    }

    public void setIgnoreInvalidCorrelationKeys(Boolean ignoreInvalidCorrelationKeys) {
        this.ignoreInvalidCorrelationKeys = ignoreInvalidCorrelationKeys;
    }

    public Integer getCloseCorrelationKeyOnCompletion() {
        return this.closeCorrelationKeyOnCompletion;
    }

    public void setCloseCorrelationKeyOnCompletion(Integer closeCorrelationKeyOnCompletion) {
        this.closeCorrelationKeyOnCompletion = closeCorrelationKeyOnCompletion;
    }

    public AggregationRepository getAggregationRepository() {
        return this.aggregationRepository;
    }

    public void setAggregationRepository(AggregationRepository aggregationRepository) {
        this.aggregationRepository = aggregationRepository;
    }

    public String getAggregationRepositoryRef() {
        return this.aggregationRepositoryRef;
    }

    public void setAggregationRepositoryRef(String aggregationRepositoryRef) {
        this.aggregationRepositoryRef = aggregationRepositoryRef;
    }

    public Boolean getDiscardOnCompletionTimeout() {
        return this.discardOnCompletionTimeout;
    }

    public void setDiscardOnCompletionTimeout(Boolean discardOnCompletionTimeout) {
        this.discardOnCompletionTimeout = discardOnCompletionTimeout;
    }

    public Boolean getDiscardOnAggregationFailure() {
        return this.discardOnAggregationFailure;
    }

    public void setDiscardOnAggregationFailure(Boolean discardOnAggregationFailure) {
        this.discardOnAggregationFailure = discardOnAggregationFailure;
    }

    public void setTimeoutCheckerExecutorService(ScheduledExecutorService timeoutCheckerExecutorService) {
        this.timeoutCheckerExecutorService = timeoutCheckerExecutorService;
    }

    public ScheduledExecutorService getTimeoutCheckerExecutorService() {
        return this.timeoutCheckerExecutorService;
    }

    public void setTimeoutCheckerExecutorServiceRef(String timeoutCheckerExecutorServiceRef) {
        this.timeoutCheckerExecutorServiceRef = timeoutCheckerExecutorServiceRef;
    }

    public String getTimeoutCheckerExecutorServiceRef() {
        return this.timeoutCheckerExecutorServiceRef;
    }

    public Boolean getForceCompletionOnStop() {
        return this.forceCompletionOnStop;
    }

    public void setForceCompletionOnStop(Boolean forceCompletionOnStop) {
        this.forceCompletionOnStop = forceCompletionOnStop;
    }

    public Boolean getCompleteAllOnStop() {
        return this.completeAllOnStop;
    }

    public void setCompleteAllOnStop(Boolean completeAllOnStop) {
        this.completeAllOnStop = completeAllOnStop;
    }

    public AggregateController getAggregateController() {
        return this.aggregateController;
    }

    public void setAggregateController(AggregateController aggregateController) {
        this.aggregateController = aggregateController;
    }

    public String getAggregateControllerRef() {
        return this.aggregateControllerRef;
    }

    public void setAggregateControllerRef(String aggregateControllerRef) {
        this.aggregateControllerRef = aggregateControllerRef;
    }

    public AggregateDefinition eagerCheckCompletion() {
        this.setEagerCheckCompletion(true);
        return this;
    }

    public AggregateDefinition ignoreInvalidCorrelationKeys() {
        this.setIgnoreInvalidCorrelationKeys(true);
        return this;
    }

    public AggregateDefinition closeCorrelationKeyOnCompletion(int capacity) {
        this.setCloseCorrelationKeyOnCompletion(capacity);
        return this;
    }

    public AggregateDefinition discardOnCompletionTimeout() {
        this.setDiscardOnCompletionTimeout(true);
        return this;
    }

    public AggregateDefinition discardOnAggregationFailure() {
        this.setDiscardOnAggregationFailure(true);
        return this;
    }

    public AggregateDefinition completionFromBatchConsumer() {
        this.setCompletionFromBatchConsumer(true);
        return this;
    }

    public AggregateDefinition completionOnNewCorrelationGroup() {
        this.setCompletionOnNewCorrelationGroup(true);
        return this;
    }

    public AggregateDefinition completionSize(int completionSize) {
        this.setCompletionSize(completionSize);
        return this;
    }

    public AggregateDefinition completionSize(Expression completionSize) {
        this.setCompletionSizeExpression(new ExpressionSubElementDefinition(completionSize));
        return this;
    }

    public AggregateDefinition completionInterval(long completionInterval) {
        this.setCompletionInterval(completionInterval);
        return this;
    }

    public AggregateDefinition completionTimeout(long completionTimeout) {
        this.setCompletionTimeout(completionTimeout);
        return this;
    }

    public AggregateDefinition completionTimeout(Expression completionTimeout) {
        this.setCompletionTimeoutExpression(new ExpressionSubElementDefinition(completionTimeout));
        return this;
    }

    public AggregateDefinition completionTimeoutCheckerInterval(long completionTimeoutCheckerInterval) {
        this.setCompletionTimeoutCheckerInterval(completionTimeoutCheckerInterval);
        return this;
    }

    public AggregationStrategyClause<AggregateDefinition> aggregationStrategy() {
        AggregationStrategyClause<AggregateDefinition> clause = new AggregationStrategyClause<AggregateDefinition>(this);
        this.setAggregationStrategy(clause);
        return clause;
    }

    @Deprecated
    public AggregationStrategyClause<AggregateDefinition> strategy() {
        return this.aggregationStrategy();
    }

    @Deprecated
    public AggregateDefinition strategy(AggregationStrategy aggregationStrategy) {
        return this.aggregationStrategy(aggregationStrategy);
    }

    public AggregateDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public AggregateDefinition aggregationStrategy(Supplier<AggregationStrategy> aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy.get());
        return this;
    }

    public AggregateDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setAggregationStrategyRef(aggregationStrategyRef);
        return this;
    }

    public AggregateDefinition aggregationStrategyMethodName(String methodName) {
        this.setAggregationStrategyMethodName(methodName);
        return this;
    }

    public AggregateDefinition aggregationStrategyMethodAllowNull() {
        this.setStrategyMethodAllowNull(true);
        return this;
    }

    public AggregateDefinition aggregationRepository(AggregationRepository aggregationRepository) {
        this.setAggregationRepository(aggregationRepository);
        return this;
    }

    public AggregateDefinition aggregationRepository(Supplier<AggregationRepository> aggregationRepository) {
        this.setAggregationRepository(aggregationRepository.get());
        return this;
    }

    public AggregateDefinition aggregationRepositoryRef(String aggregationRepositoryRef) {
        this.setAggregationRepositoryRef(aggregationRepositoryRef);
        return this;
    }

    public AggregateDefinition completionPredicate(@AsPredicate Predicate predicate) {
        this.checkNoCompletedPredicate();
        this.setCompletionPredicate(new ExpressionSubElementDefinition(predicate));
        return this;
    }

    @AsPredicate
    public PredicateClause<AggregateDefinition> completionPredicate() {
        PredicateClause<AggregateDefinition> clause = new PredicateClause<AggregateDefinition>(this);
        this.completionPredicate(clause);
        return clause;
    }

    @AsPredicate
    public PredicateClause<AggregateDefinition> completion() {
        return this.completionPredicate();
    }

    public AggregateDefinition completion(@AsPredicate Predicate predicate) {
        return this.completionPredicate(predicate);
    }

    public AggregateDefinition forceCompletionOnStop() {
        this.setForceCompletionOnStop(true);
        return this;
    }

    public AggregateDefinition completeAllOnStop() {
        this.setCompleteAllOnStop(true);
        return this;
    }

    public AggregateDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public AggregateDefinition parallelProcessing(boolean parallelProcessing) {
        this.setParallelProcessing(parallelProcessing);
        return this;
    }

    public AggregateDefinition optimisticLocking() {
        this.setOptimisticLocking(true);
        return this;
    }

    public AggregateDefinition optimisticLockRetryPolicy(OptimisticLockRetryPolicy policy) {
        this.setOptimisticLockRetryPolicy(policy);
        return this;
    }

    @Override
    public AggregateDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public AggregateDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public AggregateDefinition timeoutCheckerExecutorService(ScheduledExecutorService executorService) {
        this.setTimeoutCheckerExecutorService(executorService);
        return this;
    }

    public AggregateDefinition timeoutCheckerExecutorService(Supplier<ScheduledExecutorService> executorService) {
        this.setTimeoutCheckerExecutorService(executorService.get());
        return this;
    }

    public AggregateDefinition timeoutCheckerExecutorServiceRef(String executorServiceRef) {
        this.setTimeoutCheckerExecutorServiceRef(executorServiceRef);
        return this;
    }

    public AggregateDefinition aggregateController(AggregateController aggregateController) {
        this.setAggregateController(aggregateController);
        return this;
    }

    public AggregateDefinition aggregateController(Supplier<AggregateController> aggregateController) {
        this.setAggregateController(aggregateController.get());
        return this;
    }

    public ExpressionDefinition getExpression() {
        if (this.expression == null && this.correlationExpression != null) {
            this.expression = this.correlationExpression.getExpressionType();
        }
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    public void setExpression(Expression expression) {
        this.setExpression(new ExpressionDefinition(expression));
    }

    protected void checkNoCompletedPredicate() {
        if (this.getCompletionPredicate() != null) {
            throw new IllegalArgumentException("There is already a completionPredicate defined for this aggregator: " + this);
        }
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
    }
}

