/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.SagaActionUriDefinition;
import org.apache.camel.model.SagaCompletionMode;
import org.apache.camel.model.SagaOptionDefinition;
import org.apache.camel.model.SagaPropagation;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,routing")
@XmlRootElement(name="saga")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SagaDefinition
extends OutputDefinition<SagaDefinition> {
    @XmlAttribute
    @Metadata(defaultValue="REQUIRED")
    private SagaPropagation propagation;
    @XmlAttribute
    @Metadata(defaultValue="AUTO")
    private SagaCompletionMode completionMode;
    @XmlAttribute
    private Long timeoutInMilliseconds;
    @XmlElement
    private SagaActionUriDefinition compensation;
    @XmlElement
    private SagaActionUriDefinition completion;
    @XmlElement(name="option")
    private List<SagaOptionDefinition> options;
    @XmlTransient
    private CamelSagaService sagaService;

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    @Override
    public boolean isWrappingEntireOutput() {
        return true;
    }

    @Override
    public String getLabel() {
        String desc = this.description();
        if (ObjectHelper.isEmpty((Object)desc)) {
            return "saga";
        }
        return "saga[" + desc + "]";
    }

    @Override
    public String toString() {
        String desc = this.description();
        if (ObjectHelper.isEmpty((Object)desc)) {
            return "Saga -> [" + this.outputs + "]";
        }
        return "Saga[" + desc + "] -> [" + this.outputs + "]";
    }

    public SagaActionUriDefinition getCompensation() {
        return this.compensation;
    }

    public void setCompensation(SagaActionUriDefinition compensation) {
        this.compensation = compensation;
    }

    public SagaActionUriDefinition getCompletion() {
        return this.completion;
    }

    public void setCompletion(SagaActionUriDefinition completion) {
        this.completion = completion;
    }

    public SagaPropagation getPropagation() {
        return this.propagation;
    }

    public void setPropagation(SagaPropagation propagation) {
        this.propagation = propagation;
    }

    public SagaCompletionMode getCompletionMode() {
        return this.completionMode;
    }

    public void setCompletionMode(SagaCompletionMode completionMode) {
        this.completionMode = completionMode;
    }

    public CamelSagaService getSagaService() {
        return this.sagaService;
    }

    public void setSagaService(CamelSagaService sagaService) {
        this.sagaService = sagaService;
    }

    public List<SagaOptionDefinition> getOptions() {
        return this.options;
    }

    public void setOptions(List<SagaOptionDefinition> options) {
        this.options = options;
    }

    public Long getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public void setTimeoutInMilliseconds(Long timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    private void addOption(String option, Expression expression) {
        if (this.options == null) {
            this.options = new ArrayList<SagaOptionDefinition>();
        }
        this.options.add(new SagaOptionDefinition(option, expression));
    }

    public SagaDefinition compensation(String compensation) {
        if (this.compensation != null) {
            throw new IllegalStateException("Compensation has already been set");
        }
        this.compensation = new SagaActionUriDefinition(compensation);
        return this;
    }

    public SagaDefinition completion(String completion) {
        if (this.completion != null) {
            throw new IllegalStateException("Completion has already been set");
        }
        this.completion = new SagaActionUriDefinition(completion);
        return this;
    }

    public SagaDefinition propagation(SagaPropagation propagation) {
        this.setPropagation(propagation);
        return this;
    }

    public SagaDefinition sagaService(CamelSagaService sagaService) {
        this.setSagaService(sagaService);
        return this;
    }

    public SagaDefinition completionMode(SagaCompletionMode completionMode) {
        this.setCompletionMode(completionMode);
        return this;
    }

    public SagaDefinition option(String option, Expression expression) {
        this.addOption(option, expression);
        return this;
    }

    public SagaDefinition timeout(long timeout, TimeUnit unit) {
        this.setTimeoutInMilliseconds(unit.toMillis(timeout));
        return this;
    }

    protected String description() {
        StringBuilder desc = new StringBuilder();
        this.addField(desc, "compensation", this.compensation);
        this.addField(desc, "completion", this.completion);
        this.addField(desc, "propagation", (Object)this.propagation);
        return desc.toString();
    }

    private void addField(StringBuilder builder, String key, Object value) {
        if (value == null) {
            return;
        }
        if (builder.length() > 0) {
            builder.append(',');
        }
        builder.append(key).append(':').append(value);
    }
}

