/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.tokenizer.TokenizeLanguage;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.ExpressionToPredicateAdapter;

@Metadata(firstVersion="2.0.0", label="language,core", title="Tokenize")
@XmlRootElement(name="tokenize")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TokenizerExpression
extends ExpressionDefinition {
    @XmlAttribute(required=true)
    private String token;
    @XmlAttribute
    private String endToken;
    @XmlAttribute
    private String inheritNamespaceTagName;
    @XmlAttribute
    private String headerName;
    @XmlAttribute
    private Boolean regex;
    @XmlAttribute
    private Boolean xml;
    @XmlAttribute
    private Boolean includeTokens;
    @XmlAttribute
    private String group;
    @XmlAttribute
    private String groupDelimiter;
    @XmlAttribute
    private Boolean skipFirst;

    public TokenizerExpression() {
    }

    public TokenizerExpression(String token) {
        this.token = token;
    }

    @Override
    public String getLanguage() {
        return "tokenize";
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public Boolean getRegex() {
        return this.regex;
    }

    public String getInheritNamespaceTagName() {
        return this.inheritNamespaceTagName;
    }

    public void setInheritNamespaceTagName(String inheritNamespaceTagName) {
        this.inheritNamespaceTagName = inheritNamespaceTagName;
    }

    public Boolean getXml() {
        return this.xml;
    }

    public void setXml(Boolean xml) {
        this.xml = xml;
    }

    public Boolean getIncludeTokens() {
        return this.includeTokens;
    }

    public void setIncludeTokens(Boolean includeTokens) {
        this.includeTokens = includeTokens;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroupDelimiter() {
        return this.groupDelimiter;
    }

    public void setGroupDelimiter(String groupDelimiter) {
        this.groupDelimiter = groupDelimiter;
    }

    public Boolean getSkipFirst() {
        return this.skipFirst;
    }

    public void setSkipFirst(Boolean skipFirst) {
        this.skipFirst = skipFirst;
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        if (this.token.startsWith("\\n")) {
            this.token = '\n' + this.token.substring(2);
        }
        TokenizeLanguage language = new TokenizeLanguage();
        language.setToken(this.token);
        language.setEndToken(this.endToken);
        language.setInheritNamespaceTagName(this.inheritNamespaceTagName);
        language.setHeaderName(this.headerName);
        language.setGroupDelimiter(this.groupDelimiter);
        if (this.regex != null) {
            language.setRegex(this.regex.booleanValue());
        }
        if (this.xml != null) {
            language.setXml(this.xml.booleanValue());
        }
        if (this.includeTokens != null) {
            language.setIncludeTokens(this.includeTokens.booleanValue());
        }
        if (this.group != null && !"0".equals(this.group)) {
            language.setGroup(this.group);
        }
        if (this.skipFirst != null) {
            language.setSkipFirst(this.skipFirst.booleanValue());
        }
        return language.createExpression();
    }

    @Override
    public Predicate createPredicate(CamelContext camelContext) {
        Expression exp = this.createExpression(camelContext);
        return ExpressionToPredicateAdapter.toPredicate((Expression)exp);
    }

    @Override
    public String toString() {
        if (this.endToken != null) {
            return "tokenize{body() using tokens: " + this.token + "..." + this.endToken + "}";
        }
        return "tokenize{" + (this.headerName != null ? "header: " + this.headerName : "body()") + " using token: " + this.token + "}";
    }
}

