/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.placeholder;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.spi.PropertyPlaceholderConfigurer;

public class BeanDefinitionPropertyPlaceholderProvider
implements PropertyPlaceholderConfigurer {
    private final Map<String, Supplier<String>> readPlaceholders = new HashMap<String, Supplier<String>>();
    private final Map<String, Consumer<String>> writePlaceholders = new HashMap<String, Consumer<String>>();

    public BeanDefinitionPropertyPlaceholderProvider(Object obj) {
        BeanDefinition definition = (BeanDefinition)obj;
        this.readPlaceholders.put("ref", definition::getRef);
        this.writePlaceholders.put("ref", definition::setRef);
        this.readPlaceholders.put("method", definition::getMethod);
        this.writePlaceholders.put("method", definition::setMethod);
        this.readPlaceholders.put("beanType", definition::getBeanType);
        this.writePlaceholders.put("beanType", definition::setBeanType);
        this.readPlaceholders.put("id", definition::getId);
        this.writePlaceholders.put("id", definition::setId);
    }

    public Map<String, Supplier<String>> getReadPropertyPlaceholderOptions(CamelContext camelContext) {
        return this.readPlaceholders;
    }

    public Map<String, Consumer<String>> getWritePropertyPlaceholderOptions(CamelContext camelContext) {
        return this.writePlaceholders;
    }
}

