/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.placeholder;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.model.dataformat.BeanioDataFormat;
import org.apache.camel.spi.PropertyPlaceholderConfigurer;

public class BeanioDataFormatPropertyPlaceholderProvider
implements PropertyPlaceholderConfigurer {
    private final Map<String, Supplier<String>> readPlaceholders = new HashMap<String, Supplier<String>>();
    private final Map<String, Consumer<String>> writePlaceholders = new HashMap<String, Consumer<String>>();

    public BeanioDataFormatPropertyPlaceholderProvider(Object obj) {
        BeanioDataFormat definition = (BeanioDataFormat)obj;
        this.readPlaceholders.put("mapping", definition::getMapping);
        this.writePlaceholders.put("mapping", definition::setMapping);
        this.readPlaceholders.put("streamName", definition::getStreamName);
        this.writePlaceholders.put("streamName", definition::setStreamName);
        this.readPlaceholders.put("encoding", definition::getEncoding);
        this.writePlaceholders.put("encoding", definition::setEncoding);
        this.readPlaceholders.put("beanReaderErrorHandlerType", definition::getBeanReaderErrorHandlerType);
        this.writePlaceholders.put("beanReaderErrorHandlerType", definition::setBeanReaderErrorHandlerType);
        this.readPlaceholders.put("id", definition::getId);
        this.writePlaceholders.put("id", definition::setId);
    }

    public Map<String, Supplier<String>> getReadPropertyPlaceholderOptions(CamelContext camelContext) {
        return this.readPlaceholders;
    }

    public Map<String, Consumer<String>> getWritePropertyPlaceholderOptions(CamelContext camelContext) {
        return this.writePlaceholders;
    }
}

