/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.RouteContext;

public class BeanReifier
extends ProcessorReifier<BeanDefinition> {
    public BeanReifier(ProcessorDefinition<?> definition) {
        super((ProcessorDefinition)BeanDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        CamelContext camelContext = routeContext.getCamelContext();
        Object bean = ((BeanDefinition)this.definition).getBean();
        String ref = ((BeanDefinition)this.definition).getRef();
        String method = ((BeanDefinition)this.definition).getMethod();
        String beanType = ((BeanDefinition)this.definition).getBeanType();
        Class<?> beanClass = ((BeanDefinition)this.definition).getBeanClass();
        BeanProcessorFactory fac = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanProcessorFactory();
        if (fac == null) {
            throw new IllegalStateException("Cannot find BeanProcessorFactory. Make sure camel-bean is on the classpath.");
        }
        return fac.createBeanProcessor(camelContext, bean, beanType, beanClass, ref, method, this.isCacheBean());
    }

    private boolean isCacheBean() {
        return ((BeanDefinition)this.definition).getCache() == null || ((BeanDefinition)this.definition).getCache() != false;
    }
}

