/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.Delayer;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.spi.RouteContext;

public class DelayReifier
extends ExpressionReifier<DelayDefinition> {
    public DelayReifier(ProcessorDefinition<?> definition) {
        super((ExpressionNode)DelayDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createChildProcessor(routeContext, false);
        Expression delay = this.createAbsoluteTimeDelayExpression(routeContext);
        boolean async = ((DelayDefinition)this.definition).getAsyncDelayed() == null || ((DelayDefinition)this.definition).getAsyncDelayed() != false;
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, (ExecutorServiceAwareDefinition)((Object)this.definition), async);
        ScheduledExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredScheduledExecutorService(routeContext, "Delay", (ExecutorServiceAwareDefinition)((Object)this.definition), async);
        Delayer answer = new Delayer(routeContext.getCamelContext(), childProcessor, delay, threadPool, shutdownThreadPool);
        if (((DelayDefinition)this.definition).getAsyncDelayed() != null) {
            answer.setAsyncDelayed(((DelayDefinition)this.definition).getAsyncDelayed().booleanValue());
        }
        if (((DelayDefinition)this.definition).getCallerRunsWhenRejected() == null) {
            answer.setCallerRunsWhenRejected(true);
        } else {
            answer.setCallerRunsWhenRejected(((DelayDefinition)this.definition).getCallerRunsWhenRejected().booleanValue());
        }
        return answer;
    }

    private Expression createAbsoluteTimeDelayExpression(RouteContext routeContext) {
        ExpressionDefinition expr = ((DelayDefinition)this.definition).getExpression();
        if (expr != null) {
            return expr.createExpression(routeContext);
        }
        return null;
    }
}

