/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.Channel;
import org.apache.camel.Processor;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.reifier.loadbalancer.LoadBalancerReifier;
import org.apache.camel.spi.RouteContext;

public class LoadBalanceReifier
extends ProcessorReifier<LoadBalanceDefinition> {
    public LoadBalanceReifier(ProcessorDefinition<?> definition) {
        super((LoadBalanceDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        LoadBalancer loadBalancer = ((LoadBalanceDefinition)this.definition).getLoadBalancerType().getLoadBalancer();
        if (loadBalancer == null) {
            loadBalancer = LoadBalancerReifier.reifier(((LoadBalanceDefinition)this.definition).getLoadBalancerType()).createLoadBalancer(routeContext);
            ((LoadBalanceDefinition)this.definition).getLoadBalancerType().setLoadBalancer(loadBalancer);
            int max = ((LoadBalanceDefinition)this.definition).getLoadBalancerType().getMaximumNumberOfOutputs();
            int size = ((LoadBalanceDefinition)this.definition).getOutputs().size();
            if (size > max) {
                throw new IllegalArgumentException("To many outputs configured on " + ((LoadBalanceDefinition)this.definition).getLoadBalancerType() + ": " + size + " > " + max);
            }
            for (ProcessorDefinition<?> processorType : ((LoadBalanceDefinition)this.definition).getOutputs()) {
                if (LoadBalanceDefinition.class.isInstance(processorType)) {
                    throw new IllegalArgumentException("Loadbalancer already configured to: " + ((LoadBalanceDefinition)this.definition).getLoadBalancerType() + ". Cannot set it to: " + processorType);
                }
                Processor processor = this.createProcessor(routeContext, processorType);
                Channel channel = this.wrapChannel(routeContext, processor, processorType);
                loadBalancer.addProcessor((AsyncProcessor)channel);
            }
        }
        Boolean inherit = ((LoadBalanceDefinition)this.definition).isInheritErrorHandler();
        if (((LoadBalanceDefinition)this.definition).getLoadBalancerType() instanceof FailoverLoadBalancerDefinition) {
            inherit = true;
        }
        Channel target = this.wrapChannel(routeContext, (Processor)loadBalancer, this.definition, inherit);
        return target;
    }
}

