/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnCompletionMode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.OnCompletionProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.RouteContext;

public class OnCompletionReifier
extends ProcessorReifier<OnCompletionDefinition> {
    public OnCompletionReifier(ProcessorDefinition<?> definition) {
        super((OnCompletionDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        boolean original;
        Boolean routeScoped = ((OnCompletionDefinition)this.definition).getRouteScoped();
        if (routeScoped == null) {
            routeScoped = ((OnCompletionDefinition)this.definition).getParent() != null;
        }
        boolean isOnCompleteOnly = ((OnCompletionDefinition)this.definition).getOnCompleteOnly() != null && ((OnCompletionDefinition)this.definition).getOnCompleteOnly() != false;
        boolean isOnFailureOnly = ((OnCompletionDefinition)this.definition).getOnFailureOnly() != null && ((OnCompletionDefinition)this.definition).getOnFailureOnly() != false;
        boolean isParallelProcessing = ((OnCompletionDefinition)this.definition).getParallelProcessing() != null && ((OnCompletionDefinition)this.definition).getParallelProcessing() != false;
        boolean bl = original = ((OnCompletionDefinition)this.definition).getUseOriginalMessagePolicy() != null && ((OnCompletionDefinition)this.definition).getUseOriginalMessagePolicy() != false;
        if (isOnCompleteOnly && isOnFailureOnly) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        if (original) {
            routeContext.setAllowUseOriginalMessage(Boolean.valueOf(true));
        }
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        CamelInternalProcessor internal = new CamelInternalProcessor(childProcessor);
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.UnitOfWorkProcessorAdvice(routeContext));
        routeContext.setOnCompletion(this.getId(this.definition, routeContext), (Processor)internal);
        Predicate when = null;
        if (((OnCompletionDefinition)this.definition).getOnWhen() != null) {
            when = ((OnCompletionDefinition)this.definition).getOnWhen().getExpression().createPredicate(routeContext);
        }
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "OnCompletion", (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        boolean afterConsumer = ((OnCompletionDefinition)this.definition).getMode() == null || ((OnCompletionDefinition)this.definition).getMode() == OnCompletionMode.AfterConsumer;
        OnCompletionProcessor answer = new OnCompletionProcessor(routeContext.getCamelContext(), (Processor)internal, threadPool, shutdownThreadPool, isOnCompleteOnly, isOnFailureOnly, when, original, afterConsumer);
        return answer;
    }
}

