/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Processor;
import org.apache.camel.builder.ThreadPoolProfileBuilder;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.processor.ThreadsProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;

public class ThreadsReifier
extends ProcessorReifier<ThreadsDefinition> {
    public ThreadsReifier(ProcessorDefinition<?> definition) {
        super((ThreadsDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        String name = ((ThreadsDefinition)this.definition).getThreadName() != null ? ((ThreadsDefinition)this.definition).getThreadName() : "Threads";
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, (ExecutorServiceAwareDefinition)((Object)this.definition), true);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, name, (ExecutorServiceAwareDefinition)((Object)this.definition), false);
        ThreadPoolRejectedPolicy policy = this.resolveRejectedPolicy(routeContext);
        if (policy == null) {
            policy = ((ThreadsDefinition)this.definition).getCallerRunsWhenRejected() == null || ((ThreadsDefinition)this.definition).getCallerRunsWhenRejected() != false ? ThreadPoolRejectedPolicy.CallerRuns : ThreadPoolRejectedPolicy.Abort;
        }
        this.log.debug("Using ThreadPoolRejectedPolicy: {}", (Object)policy);
        if (threadPool == null) {
            ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
            ThreadPoolProfile profile = new ThreadPoolProfileBuilder(name).poolSize(((ThreadsDefinition)this.definition).getPoolSize()).maxPoolSize(((ThreadsDefinition)this.definition).getMaxPoolSize()).keepAliveTime(((ThreadsDefinition)this.definition).getKeepAliveTime(), ((ThreadsDefinition)this.definition).getTimeUnit()).maxQueueSize(((ThreadsDefinition)this.definition).getMaxQueueSize()).rejectedPolicy(policy).allowCoreThreadTimeOut(((ThreadsDefinition)this.definition).getAllowCoreThreadTimeOut()).build();
            threadPool = manager.newThreadPool((Object)this.definition, name, profile);
            shutdownThreadPool = true;
        } else {
            if (((ThreadsDefinition)this.definition).getThreadName() != null && !((ThreadsDefinition)this.definition).getThreadName().equals("Threads")) {
                throw new IllegalArgumentException("ThreadName and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getPoolSize() != null) {
                throw new IllegalArgumentException("PoolSize and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getMaxPoolSize() != null) {
                throw new IllegalArgumentException("MaxPoolSize and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getKeepAliveTime() != null) {
                throw new IllegalArgumentException("KeepAliveTime and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getTimeUnit() != null) {
                throw new IllegalArgumentException("TimeUnit and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getMaxQueueSize() != null) {
                throw new IllegalArgumentException("MaxQueueSize and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getRejectedPolicy() != null) {
                throw new IllegalArgumentException("RejectedPolicy and executorServiceRef options cannot be used together.");
            }
            if (((ThreadsDefinition)this.definition).getAllowCoreThreadTimeOut() != null) {
                throw new IllegalArgumentException("AllowCoreThreadTimeOut and executorServiceRef options cannot be used together.");
            }
        }
        return new ThreadsProcessor(routeContext.getCamelContext(), threadPool, shutdownThreadPool, policy);
    }

    protected ThreadPoolRejectedPolicy resolveRejectedPolicy(RouteContext routeContext) {
        ThreadPoolProfile threadPoolProfile;
        if (((ThreadsDefinition)this.definition).getExecutorServiceRef() != null && ((ThreadsDefinition)this.definition).getRejectedPolicy() == null && (threadPoolProfile = routeContext.getCamelContext().getExecutorServiceManager().getThreadPoolProfile(((ThreadsDefinition)this.definition).getExecutorServiceRef())) != null) {
            return threadPoolProfile.getRejectedPolicy();
        }
        return ((ThreadsDefinition)this.definition).getRejectedPolicy();
    }
}

