/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.CsvDataFormat;
import org.apache.camel.reifier.dataformat.DataFormatReifier;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class CsvDataFormatReifier
extends DataFormatReifier<CsvDataFormat> {
    public CsvDataFormatReifier(DataFormatDefinition definition) {
        super((CsvDataFormat)definition);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (ObjectHelper.isNotEmpty((Object)((CsvDataFormat)this.definition).getFormatRef())) {
            Object format = CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)((CsvDataFormat)this.definition).getFormatRef());
            this.setProperty(camelContext, dataFormat, "format", format);
        } else if (ObjectHelper.isNotEmpty((Object)((CsvDataFormat)this.definition).getFormatName())) {
            this.setProperty(camelContext, dataFormat, "formatName", ((CsvDataFormat)this.definition).getFormatName());
        }
        if (((CsvDataFormat)this.definition).getCommentMarkerDisabled() != null) {
            this.setProperty(camelContext, dataFormat, "commentMarkerDisabled", ((CsvDataFormat)this.definition).getCommentMarkerDisabled());
        }
        if (((CsvDataFormat)this.definition).getCommentMarker() != null) {
            this.setProperty(camelContext, dataFormat, "commentMarker", CsvDataFormatReifier.singleChar(((CsvDataFormat)this.definition).getCommentMarker(), "commentMarker"));
        }
        if (((CsvDataFormat)this.definition).getDelimiter() != null) {
            this.setProperty(camelContext, dataFormat, "delimiter", CsvDataFormatReifier.singleChar(((CsvDataFormat)this.definition).getDelimiter(), "delimiter"));
        }
        if (((CsvDataFormat)this.definition).getEscapeDisabled() != null) {
            this.setProperty(camelContext, dataFormat, "escapeDisabled", ((CsvDataFormat)this.definition).getEscapeDisabled());
        }
        if (((CsvDataFormat)this.definition).getEscape() != null) {
            this.setProperty(camelContext, dataFormat, "escape", CsvDataFormatReifier.singleChar(((CsvDataFormat)this.definition).getEscape(), "escape"));
        }
        if (((CsvDataFormat)this.definition).getHeaderDisabled() != null) {
            this.setProperty(camelContext, dataFormat, "headerDisabled", ((CsvDataFormat)this.definition).getHeaderDisabled());
        }
        if (((CsvDataFormat)this.definition).getHeader() != null && !((CsvDataFormat)this.definition).getHeader().isEmpty()) {
            this.setProperty(camelContext, dataFormat, "header", ((CsvDataFormat)this.definition).getHeader().toArray(new String[((CsvDataFormat)this.definition).getHeader().size()]));
        }
        if (((CsvDataFormat)this.definition).getAllowMissingColumnNames() != null) {
            this.setProperty(camelContext, dataFormat, "allowMissingColumnNames", ((CsvDataFormat)this.definition).getAllowMissingColumnNames());
        }
        if (((CsvDataFormat)this.definition).getIgnoreEmptyLines() != null) {
            this.setProperty(camelContext, dataFormat, "ignoreEmptyLines", ((CsvDataFormat)this.definition).getIgnoreEmptyLines());
        }
        if (((CsvDataFormat)this.definition).getIgnoreSurroundingSpaces() != null) {
            this.setProperty(camelContext, dataFormat, "ignoreSurroundingSpaces", ((CsvDataFormat)this.definition).getIgnoreSurroundingSpaces());
        }
        if (((CsvDataFormat)this.definition).getNullStringDisabled() != null) {
            this.setProperty(camelContext, dataFormat, "nullStringDisabled", ((CsvDataFormat)this.definition).getNullStringDisabled());
        }
        if (((CsvDataFormat)this.definition).getNullString() != null) {
            this.setProperty(camelContext, dataFormat, "nullString", ((CsvDataFormat)this.definition).getNullString());
        }
        if (((CsvDataFormat)this.definition).getQuoteDisabled() != null) {
            this.setProperty(camelContext, dataFormat, "quoteDisabled", ((CsvDataFormat)this.definition).getQuoteDisabled());
        }
        if (((CsvDataFormat)this.definition).getQuote() != null) {
            this.setProperty(camelContext, dataFormat, "quote", CsvDataFormatReifier.singleChar(((CsvDataFormat)this.definition).getQuote(), "quote"));
        }
        if (((CsvDataFormat)this.definition).getRecordSeparatorDisabled() != null) {
            this.setProperty(camelContext, dataFormat, "recordSeparatorDisabled", ((CsvDataFormat)this.definition).getRecordSeparatorDisabled());
        }
        if (((CsvDataFormat)this.definition).getRecordSeparator() != null) {
            this.setProperty(camelContext, dataFormat, "recordSeparator", ((CsvDataFormat)this.definition).getRecordSeparator());
        }
        if (((CsvDataFormat)this.definition).getSkipHeaderRecord() != null) {
            this.setProperty(camelContext, dataFormat, "skipHeaderRecord", ((CsvDataFormat)this.definition).getSkipHeaderRecord());
        }
        if (((CsvDataFormat)this.definition).getQuoteMode() != null) {
            this.setProperty(camelContext, dataFormat, "quoteMode", ((CsvDataFormat)this.definition).getQuoteMode());
        }
        if (((CsvDataFormat)this.definition).getTrim() != null) {
            this.setProperty(camelContext, dataFormat, "trim", ((CsvDataFormat)this.definition).getTrim());
        }
        if (((CsvDataFormat)this.definition).getIgnoreHeaderCase() != null) {
            this.setProperty(camelContext, dataFormat, "ignoreHeaderCase", ((CsvDataFormat)this.definition).getIgnoreHeaderCase());
        }
        if (((CsvDataFormat)this.definition).getTrailingDelimiter() != null) {
            this.setProperty(camelContext, dataFormat, "trailingDelimiter", ((CsvDataFormat)this.definition).getTrailingDelimiter());
        }
        if (((CsvDataFormat)this.definition).getLazyLoad() != null) {
            this.setProperty(camelContext, dataFormat, "lazyLoad", ((CsvDataFormat)this.definition).getLazyLoad());
        }
        if (((CsvDataFormat)this.definition).getUseMaps() != null) {
            this.setProperty(camelContext, dataFormat, "useMaps", ((CsvDataFormat)this.definition).getUseMaps());
        }
        if (((CsvDataFormat)this.definition).getUseOrderedMaps() != null) {
            this.setProperty(camelContext, dataFormat, "useOrderedMaps", ((CsvDataFormat)this.definition).getUseOrderedMaps());
        }
        if (ObjectHelper.isNotEmpty((Object)((CsvDataFormat)this.definition).getRecordConverterRef())) {
            Object recordConverter = CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)((CsvDataFormat)this.definition).getRecordConverterRef());
            this.setProperty(camelContext, dataFormat, "recordConverter", recordConverter);
        }
        if (ObjectHelper.isNotEmpty((Object)((CsvDataFormat)this.definition).getMarshallerFactoryRef())) {
            Object marshallerFactory = CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)((CsvDataFormat)this.definition).getMarshallerFactoryRef().trim());
            this.setProperty(camelContext, dataFormat, "marshallerFactory", marshallerFactory);
        }
    }

    private static Character singleChar(String value, String attributeName) {
        if (value.length() != 1) {
            throw new IllegalArgumentException(String.format("The '%s' attribute must be exactly one character long.", attributeName));
        }
        return Character.valueOf(value.charAt(0));
    }
}

