/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.FhirDataformat;
import org.apache.camel.reifier.dataformat.DataFormatReifier;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

public class FhirDataFormatReifier<T extends FhirDataformat>
extends DataFormatReifier<T> {
    public FhirDataFormatReifier(DataFormatDefinition definition) {
        super((FhirDataformat)definition);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        Boolean answer;
        if (((FhirDataformat)this.definition).getContentTypeHeader() != null) {
            this.setProperty(camelContext, dataFormat, "contentTypeHeader", ((FhirDataformat)this.definition).getContentTypeHeader());
        }
        if (((FhirDataformat)this.definition).getFhirContext() != null) {
            this.setProperty(camelContext, dataFormat, "fhirContext", ((FhirDataformat)this.definition).getFhirContext());
        }
        if (((FhirDataformat)this.definition).getFhirVersion() != null) {
            this.setProperty(camelContext, dataFormat, "fhirVersion", ((FhirDataformat)this.definition).getFhirVersion());
        }
        if (ObjectHelper.isNotEmpty(((FhirDataformat)this.definition).getDontStripVersionsFromReferencesAtPaths())) {
            this.setProperty(camelContext, dataFormat, "dontStripVersionsFromReferencesAtPaths", ((FhirDataformat)this.definition).getDontStripVersionsFromReferencesAtPaths());
        }
        if (ObjectHelper.isNotEmpty(((FhirDataformat)this.definition).getDontEncodeElements())) {
            this.setProperty(camelContext, dataFormat, "dontEncodeElements", ((FhirDataformat)this.definition).getDontEncodeElements());
        }
        if (ObjectHelper.isNotEmpty(((FhirDataformat)this.definition).getEncodeElements())) {
            this.setProperty(camelContext, dataFormat, "encodeElements", ((FhirDataformat)this.definition).getEncodeElements());
        }
        if (ObjectHelper.isNotEmpty((Object)((FhirDataformat)this.definition).getServerBaseUrl())) {
            this.setProperty(camelContext, dataFormat, "serverBaseUrl", ((FhirDataformat)this.definition).getServerBaseUrl());
        }
        if (ObjectHelper.isNotEmpty((Object)((FhirDataformat)this.definition).getForceResourceId())) {
            this.setProperty(camelContext, dataFormat, "forceResourceId", ((FhirDataformat)this.definition).getForceResourceId());
        }
        if (ObjectHelper.isNotEmpty((Object)((FhirDataformat)this.definition).getPreferTypes())) {
            this.setProperty(camelContext, dataFormat, "preferTypes", ((FhirDataformat)this.definition).getPreferTypes());
        }
        if (ObjectHelper.isNotEmpty((Object)((FhirDataformat)this.definition).getParserOptions())) {
            this.setProperty(camelContext, dataFormat, "parserOptions", ((FhirDataformat)this.definition).getParserOptions());
        }
        if (ObjectHelper.isNotEmpty((Object)((FhirDataformat)this.definition).getParserErrorHandler())) {
            this.setProperty(camelContext, dataFormat, "parserErrorHandler", ((FhirDataformat)this.definition).getParserErrorHandler());
        }
        if ((answer = ObjectHelper.toBoolean((Object)((FhirDataformat)this.definition).isEncodeElementsAppliesToChildResourcesOnly())) != null) {
            this.setProperty(camelContext, dataFormat, "encodeElementsAppliesToChildResourcesOnly", answer);
        }
        if ((answer = ObjectHelper.toBoolean((Object)((FhirDataformat)this.definition).isOmitResourceId())) != null) {
            this.setProperty(camelContext, dataFormat, "omitResourceId", answer);
        }
        if ((answer = ObjectHelper.toBoolean((Object)((FhirDataformat)this.definition).isPrettyPrint())) != null) {
            this.setProperty(camelContext, dataFormat, "prettyPrint", answer);
        }
        if ((answer = ObjectHelper.toBoolean((Object)((FhirDataformat)this.definition).isSuppressNarratives())) != null) {
            this.setProperty(camelContext, dataFormat, "suppressNarratives", answer);
        }
        if ((answer = ObjectHelper.toBoolean((Object)((FhirDataformat)this.definition).isSummaryMode())) != null) {
            this.setProperty(camelContext, dataFormat, "summaryMode", answer);
        }
        if ((answer = ObjectHelper.toBoolean((Object)((FhirDataformat)this.definition).getOverrideResourceIdWithBundleEntryFullUrl())) != null) {
            this.setProperty(camelContext, dataFormat, "overrideResourceIdWithBundleEntryFullUrl", answer);
        }
        if ((answer = ObjectHelper.toBoolean((Object)((FhirDataformat)this.definition).getStripVersionsFromReferences())) != null) {
            this.setProperty(camelContext, dataFormat, "stripVersionsFromReferences", answer);
        }
    }
}

