/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.FlatpackDataFormat;
import org.apache.camel.reifier.dataformat.DataFormatReifier;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class FlatpackDataFormatReifier
extends DataFormatReifier<FlatpackDataFormat> {
    public FlatpackDataFormatReifier(DataFormatDefinition definition) {
        super((FlatpackDataFormat)definition);
    }

    @Override
    protected DataFormat doCreateDataFormat(CamelContext camelContext) {
        DataFormat flatpack = super.doCreateDataFormat(camelContext);
        if (ObjectHelper.isNotEmpty((Object)((FlatpackDataFormat)this.definition).getParserFactoryRef())) {
            Object parserFactory = CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)((FlatpackDataFormat)this.definition).getParserFactoryRef());
            this.setProperty(camelContext, flatpack, "parserFactory", parserFactory);
        }
        return flatpack;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (ObjectHelper.isNotEmpty((Object)((FlatpackDataFormat)this.definition).getDefinition())) {
            this.setProperty(camelContext, dataFormat, "definition", ((FlatpackDataFormat)this.definition).getDefinition());
        }
        if (((FlatpackDataFormat)this.definition).getFixed() != null) {
            this.setProperty(camelContext, dataFormat, "fixed", ((FlatpackDataFormat)this.definition).getFixed());
        }
        if (((FlatpackDataFormat)this.definition).getIgnoreFirstRecord() != null) {
            this.setProperty(camelContext, dataFormat, "ignoreFirstRecord", ((FlatpackDataFormat)this.definition).getIgnoreFirstRecord());
        }
        if (ObjectHelper.isNotEmpty((Object)((FlatpackDataFormat)this.definition).getTextQualifier())) {
            if (((FlatpackDataFormat)this.definition).getTextQualifier().length() > 1) {
                throw new IllegalArgumentException("Text qualifier must be one character long!");
            }
            this.setProperty(camelContext, dataFormat, "textQualifier", Character.valueOf(((FlatpackDataFormat)this.definition).getTextQualifier().charAt(0)));
        }
        if (ObjectHelper.isNotEmpty((Object)((FlatpackDataFormat)this.definition).getDelimiter())) {
            if (((FlatpackDataFormat)this.definition).getDelimiter().length() > 1) {
                throw new IllegalArgumentException("Delimiter must be one character long!");
            }
            this.setProperty(camelContext, dataFormat, "delimiter", Character.valueOf(((FlatpackDataFormat)this.definition).getDelimiter().charAt(0)));
        }
        if (((FlatpackDataFormat)this.definition).getAllowShortLines() != null) {
            this.setProperty(camelContext, dataFormat, "allowShortLines", ((FlatpackDataFormat)this.definition).getAllowShortLines());
        }
        if (((FlatpackDataFormat)this.definition).getIgnoreExtraColumns() != null) {
            this.setProperty(camelContext, dataFormat, "ignoreExtraColumns", ((FlatpackDataFormat)this.definition).getIgnoreExtraColumns());
        }
    }
}

