/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.transformer;

import org.apache.camel.CamelContext;
import org.apache.camel.model.transformer.CustomTransformerDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.reifier.transformer.TransformerReifier;
import org.apache.camel.spi.Transformer;

public class CustomTransformeReifier
extends TransformerReifier<CustomTransformerDefinition> {
    public CustomTransformeReifier(TransformerDefinition definition) {
        super((CustomTransformerDefinition)definition);
    }

    @Override
    protected Transformer doCreateTransformer(CamelContext context) throws Exception {
        Transformer transformer;
        if (((CustomTransformerDefinition)this.definition).getRef() == null && ((CustomTransformerDefinition)this.definition).getClassName() == null) {
            throw new IllegalArgumentException("'ref' or 'className' must be specified for customTransformer");
        }
        if (((CustomTransformerDefinition)this.definition).getRef() != null) {
            transformer = (Transformer)context.getRegistry().lookupByNameAndType(((CustomTransformerDefinition)this.definition).getRef(), Transformer.class);
            if (transformer == null) {
                throw new IllegalArgumentException("Cannot find transformer with ref:" + ((CustomTransformerDefinition)this.definition).getRef());
            }
            if (transformer.getModel() != null || transformer.getFrom() != null || transformer.getTo() != null) {
                throw new IllegalArgumentException(String.format("Transformer '%s' is already in use. Please check if duplicate transformer exists.", ((CustomTransformerDefinition)this.definition).getRef()));
            }
        } else {
            Class transformerClass = context.getClassResolver().resolveMandatoryClass(((CustomTransformerDefinition)this.definition).getClassName(), Transformer.class);
            if (transformerClass == null) {
                throw new IllegalArgumentException("Cannot find transformer class: " + ((CustomTransformerDefinition)this.definition).getClassName());
            }
            transformer = (Transformer)context.getInjector().newInstance(transformerClass, false);
        }
        transformer.setCamelContext(context);
        return transformer.setModel(((CustomTransformerDefinition)this.definition).getScheme()).setFrom(((CustomTransformerDefinition)this.definition).getFromType()).setTo(((CustomTransformerDefinition)this.definition).getToType());
    }
}

