/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.FailedToCreateRouteFromTemplateException;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.impl.DefaultModelReifierFactory;
import org.apache.camel.impl.PreconditionHelper;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.DefaultRouteTemplateContext;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.PreconditionContainer;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RouteFilters;
import org.apache.camel.model.RouteTemplateBeanDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.TemplatedRouteBeanDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.TemplatedRouteParameterDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.app.RegistryBeanDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.RouteTemplateLoaderListener;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.RouteTemplateHelper;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.function.Suppliers;

public class DefaultModel
implements Model {
    private final CamelContext camelContext;
    private ModelReifierFactory modelReifierFactory = new DefaultModelReifierFactory();
    private final List<ModelLifecycleStrategy> modelLifecycleStrategies = new ArrayList<ModelLifecycleStrategy>();
    private final List<RouteConfigurationDefinition> routesConfigurations = new ArrayList<RouteConfigurationDefinition>();
    private final List<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
    private final List<RouteTemplateDefinition> routeTemplateDefinitions = new ArrayList<RouteTemplateDefinition>();
    private final List<RestDefinition> restDefinitions = new ArrayList<RestDefinition>();
    private final Map<String, RouteTemplateDefinition.Converter> routeTemplateConverters = new ConcurrentHashMap<String, RouteTemplateDefinition.Converter>();
    private Map<String, DataFormatDefinition> dataFormats = new HashMap<String, DataFormatDefinition>();
    private List<TransformerDefinition> transformers = new ArrayList<TransformerDefinition>();
    private List<ValidatorDefinition> validators = new ArrayList<ValidatorDefinition>();
    private final List<RegistryBeanDefinition> beans = new ArrayList<RegistryBeanDefinition>();
    private final Map<String, ServiceCallConfigurationDefinition> serviceCallConfigurations = new ConcurrentHashMap<String, ServiceCallConfigurationDefinition>();
    private final Map<String, Resilience4jConfigurationDefinition> resilience4jConfigurations = new ConcurrentHashMap<String, Resilience4jConfigurationDefinition>();
    private final Map<String, FaultToleranceConfigurationDefinition> faultToleranceConfigurations = new ConcurrentHashMap<String, FaultToleranceConfigurationDefinition>();
    private Function<RouteDefinition, Boolean> routeFilter;

    public DefaultModel(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void addModelLifecycleStrategy(ModelLifecycleStrategy modelLifecycleStrategy) {
        if (!this.modelLifecycleStrategies.contains(modelLifecycleStrategy)) {
            this.modelLifecycleStrategies.add(modelLifecycleStrategy);
        }
    }

    public List<ModelLifecycleStrategy> getModelLifecycleStrategies() {
        return this.modelLifecycleStrategies;
    }

    public void addRouteConfiguration(RouteConfigurationDefinition routesConfiguration) {
        if (routesConfiguration == null || !this.includedRouteConfiguration(routesConfiguration)) {
            return;
        }
        if (!this.routesConfigurations.contains(routesConfiguration)) {
            boolean clash;
            if (routesConfiguration.getId() != null && (clash = this.routesConfigurations.stream().anyMatch(r -> ObjectHelper.equal((Object)r.getId(), (Object)routesConfiguration.getId())))) {
                throw new IllegalArgumentException("Route configuration already exists with id: " + routesConfiguration.getId());
            }
            this.routesConfigurations.add(routesConfiguration);
        }
    }

    public void addRouteConfigurations(List<RouteConfigurationDefinition> routesConfigurations) {
        if (routesConfigurations == null || routesConfigurations.isEmpty()) {
            return;
        }
        for (RouteConfigurationDefinition rc : routesConfigurations) {
            this.addRouteConfiguration(rc);
        }
    }

    public List<RouteConfigurationDefinition> getRouteConfigurationDefinitions() {
        return this.routesConfigurations;
    }

    public synchronized RouteConfigurationDefinition getRouteConfigurationDefinition(String id) {
        for (RouteConfigurationDefinition def : this.routesConfigurations) {
            if (!def.idOrCreate((NodeIdFactory)this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class)).equals(id)) continue;
            return def;
        }
        return this.routesConfigurations.stream().filter(c -> c.getId() == null).findFirst().orElse(null);
    }

    public void removeRouteConfiguration(RouteConfigurationDefinition routeConfigurationDefinition) throws Exception {
        RouteConfigurationDefinition toBeRemoved = this.getRouteConfigurationDefinition(routeConfigurationDefinition.getId());
        this.routesConfigurations.remove(toBeRemoved);
    }

    public synchronized void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        ArrayList<RouteDefinition> list;
        if (routeDefinitions == null || routeDefinitions.isEmpty()) {
            return;
        }
        if (this.routeFilter == null) {
            list = new ArrayList<RouteDefinition>(routeDefinitions);
        } else {
            list = new ArrayList();
            for (RouteDefinition r : routeDefinitions) {
                if (!this.routeFilter.apply(r).booleanValue()) continue;
                list.add(r);
            }
        }
        this.removeRouteDefinitions(list);
        if (this.camelContext.getRestConfiguration().isInlineRoutes()) {
            String uri;
            FromDefinition from;
            ArrayList<RouteDefinition> allRoutes = new ArrayList<RouteDefinition>();
            allRoutes.addAll(list);
            allRoutes.addAll(this.routeDefinitions);
            ArrayList<RouteDefinition> toBeRemoved = new ArrayList<RouteDefinition>();
            HashMap<String, RouteDefinition> directs = new HashMap<String, RouteDefinition>();
            for (RouteDefinition r : allRoutes) {
                from = r.getInput();
                if (from == null || (uri = from.getEndpointUri()) == null || !uri.startsWith("direct:")) continue;
                directs.put(uri, r);
            }
            for (RouteDefinition r : allRoutes) {
                ToDefinition to;
                String toUri;
                RouteDefinition toBeInlined;
                ProcessorDefinition def;
                from = r.getInput();
                if (from == null || (uri = from.getEndpointUri()) == null || !uri.startsWith("rest:") || !((def = (ProcessorDefinition)r.getOutputs().get(0)) instanceof ToDefinition) || (toBeInlined = (RouteDefinition)directs.get(toUri = (to = (ToDefinition)def).getEndpointUri())) == null) continue;
                toBeRemoved.add(toBeInlined);
                FromDefinition inlinedFrom = toBeInlined.getInput();
                from.setLocation(inlinedFrom.getLocation());
                from.setLineNumber(inlinedFrom.getLineNumber());
                r.getOutputs().clear();
                r.getOutputs().addAll(toBeInlined.getOutputs());
                if (toBeInlined.getRouteId() != null) {
                    r.setId(toBeInlined.getRouteId());
                }
                r.setNodePrefixId(toBeInlined.getNodePrefixId());
                r.setGroup(toBeInlined.getGroup());
                r.setAutoStartup(toBeInlined.getAutoStartup());
                r.setDelayer(toBeInlined.getDelayer());
                r.setInputType(toBeInlined.getInputType());
                r.setOutputType(toBeInlined.getOutputType());
                r.setLogMask(toBeInlined.getLogMask());
                r.setMessageHistory(toBeInlined.getMessageHistory());
                r.setStreamCache(toBeInlined.getStreamCache());
                r.setTrace(toBeInlined.getTrace());
                r.setStartupOrder(toBeInlined.getStartupOrder());
                r.setRoutePolicyRef(toBeInlined.getRoutePolicyRef());
                r.setRouteConfigurationId(toBeInlined.getRouteConfigurationId());
                r.setRoutePolicies(toBeInlined.getRoutePolicies());
                r.setShutdownRoute(toBeInlined.getShutdownRoute());
                r.setShutdownRunningTask(toBeInlined.getShutdownRunningTask());
                r.setErrorHandlerRef(toBeInlined.getErrorHandlerRef());
                r.setPrecondition(toBeInlined.getPrecondition());
                if (!toBeInlined.isErrorHandlerFactorySet()) continue;
                r.setErrorHandlerFactory(toBeInlined.getErrorHandlerFactory());
            }
            list.removeAll(toBeRemoved);
            this.routeDefinitions.removeAll(toBeRemoved);
        }
        for (RouteDefinition r : list) {
            for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
                s.onAddRouteDefinition(r);
            }
            this.routeDefinitions.add(r);
        }
        if (this.shouldStartRoutes()) {
            ((ModelCamelContext)this.getCamelContext()).startRouteDefinitions(list);
        }
    }

    public void addRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        this.addRouteDefinitions(Collections.singletonList(routeDefinition));
    }

    public synchronized void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.removeRouteDefinition(routeDefinition);
        }
    }

    public synchronized void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        RouteDefinition toBeRemoved = routeDefinition;
        String id = routeDefinition.getId();
        if (id != null) {
            this.camelContext.getRouteController().stopRoute(id);
            this.camelContext.removeRoute(id);
            toBeRemoved = this.getRouteDefinition(id);
        }
        for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
            s.onRemoveRouteDefinition(toBeRemoved);
        }
        this.routeDefinitions.remove(toBeRemoved);
    }

    public synchronized void removeRouteTemplateDefinitions(String pattern) throws Exception {
        for (RouteTemplateDefinition def : new ArrayList<RouteTemplateDefinition>(this.routeTemplateDefinitions)) {
            if (!PatternHelper.matchPattern((String)def.getId(), (String)pattern)) continue;
            this.removeRouteTemplateDefinition(def);
        }
    }

    public synchronized List<RouteDefinition> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    public synchronized RouteDefinition getRouteDefinition(String id) {
        for (RouteDefinition route : this.routeDefinitions) {
            if (!route.idOrCreate((NodeIdFactory)this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class)).equals(id)) continue;
            return route;
        }
        return null;
    }

    public List<RouteTemplateDefinition> getRouteTemplateDefinitions() {
        return this.routeTemplateDefinitions;
    }

    public RouteTemplateDefinition getRouteTemplateDefinition(String id) {
        for (RouteTemplateDefinition route : this.routeTemplateDefinitions) {
            if (!route.idOrCreate((NodeIdFactory)this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class)).equals(id)) continue;
            return route;
        }
        return null;
    }

    public void addRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        if (routeTemplateDefinitions == null || routeTemplateDefinitions.isEmpty()) {
            return;
        }
        for (RouteTemplateDefinition r : routeTemplateDefinitions) {
            for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
                s.onAddRouteTemplateDefinition(r);
            }
            this.routeTemplateDefinitions.add(r);
        }
    }

    public void addRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        this.addRouteTemplateDefinitions(Collections.singletonList(routeTemplateDefinition));
    }

    public void removeRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        for (RouteTemplateDefinition r : routeTemplateDefinitions) {
            this.removeRouteTemplateDefinition(r);
        }
    }

    public void removeRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
            s.onRemoveRouteTemplateDefinition(routeTemplateDefinition);
        }
        this.routeTemplateDefinitions.remove(routeTemplateDefinition);
    }

    public void addRouteTemplateDefinitionConverter(String templateIdPattern, RouteTemplateDefinition.Converter converter) {
        this.routeTemplateConverters.put(templateIdPattern, converter);
    }

    @Deprecated
    public String addRouteFromTemplate(String routeId, String routeTemplateId, Map<String, Object> parameters) throws Exception {
        DefaultRouteTemplateContext rtc = new DefaultRouteTemplateContext(this.camelContext);
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((RouteTemplateContext)rtc).setParameter(arg_0, arg_1));
        }
        return this.addRouteFromTemplate(routeId, routeTemplateId, null, (RouteTemplateContext)rtc);
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, Map<String, Object> parameters) throws Exception {
        DefaultRouteTemplateContext rtc = new DefaultRouteTemplateContext(this.camelContext);
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((RouteTemplateContext)rtc).setParameter(arg_0, arg_1));
        }
        return this.addRouteFromTemplate(routeId, routeTemplateId, prefixId, (RouteTemplateContext)rtc);
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, RouteTemplateContext routeTemplateContext) throws Exception {
        return this.addRouteFromTemplate(routeId, routeTemplateId, null, routeTemplateContext);
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, RouteTemplateContext routeTemplateContext) throws Exception {
        String string;
        RouteTemplateDefinition target = null;
        for (RouteTemplateDefinition def : this.routeTemplateDefinitions) {
            if (!routeTemplateId.equals(def.getId())) continue;
            target = def;
            break;
        }
        if (target == null) {
            Object location = routeTemplateContext.getParameters().get("location");
            if (location != null) {
                RouteTemplateLoaderListener listener = (RouteTemplateLoaderListener)CamelContextHelper.findSingleByType((CamelContext)this.getCamelContext(), RouteTemplateLoaderListener.class);
                RouteTemplateHelper.loadRouteTemplateFromLocation((CamelContext)this.getCamelContext(), (RouteTemplateLoaderListener)listener, (String)routeTemplateId, (String)location.toString());
            }
            for (RouteTemplateDefinition def : this.routeTemplateDefinitions) {
                if (!routeTemplateId.equals(def.getId())) continue;
                target = def;
                break;
            }
        }
        if (target == null) {
            throw new IllegalArgumentException("Cannot find RouteTemplate with id " + routeTemplateId);
        }
        HashMap<String, Object> prop = new HashMap<String, Object>();
        HashMap<String, Object> propDefaultValues = new HashMap<String, Object>();
        if (target.getTemplateParameters() != null) {
            StringJoiner templatesBuilder = new StringJoiner(", ");
            for (RouteTemplateParameterDefinition routeTemplateParameterDefinition : target.getTemplateParameters()) {
                if (routeTemplateParameterDefinition.getDefaultValue() != null) {
                    DefaultModel.addProperty(prop, routeTemplateParameterDefinition.getName(), routeTemplateParameterDefinition.getDefaultValue());
                    DefaultModel.addProperty(propDefaultValues, routeTemplateParameterDefinition.getName(), routeTemplateParameterDefinition.getDefaultValue());
                    continue;
                }
                if (!routeTemplateParameterDefinition.isRequired() || routeTemplateContext.hasParameter(routeTemplateParameterDefinition.getName())) continue;
                templatesBuilder.add(routeTemplateParameterDefinition.getName());
            }
            if (templatesBuilder.length() > 0) {
                throw new IllegalArgumentException("Route template " + routeTemplateId + " the following mandatory parameters must be provided: " + String.valueOf(templatesBuilder));
            }
        }
        if (routeTemplateContext.getParameters() != null) {
            routeTemplateContext.getParameters().forEach((k, v) -> DefaultModel.addProperty(prop, k, v));
        }
        if (target.getTemplateParameters() != null) {
            for (RouteTemplateParameterDefinition temp : target.getTemplateParameters()) {
                if (routeTemplateContext.hasParameter(temp.getName()) || temp.getDefaultValue() == null) continue;
                routeTemplateContext.setParameter(temp.getName(), (Object)temp.getDefaultValue());
            }
        }
        RouteTemplateDefinition.Converter converter = RouteTemplateDefinition.Converter.DEFAULT_CONVERTER;
        for (Map.Entry entry : this.routeTemplateConverters.entrySet()) {
            String key = (String)entry.getKey();
            String templateId = target.getId();
            if ("*".equals(key) || templateId.equals(key)) {
                converter = (RouteTemplateDefinition.Converter)entry.getValue();
                break;
            }
            if (AntPathMatcher.INSTANCE.match(key, templateId)) {
                converter = (RouteTemplateDefinition.Converter)entry.getValue();
                break;
            }
            if (!templateId.matches(key)) continue;
            converter = (RouteTemplateDefinition.Converter)entry.getValue();
            break;
        }
        RouteDefinition def = converter.apply(target, prop);
        if (routeId != null) {
            def.setId(routeId);
        }
        if (prefixId != null) {
            def.setNodePrefixId(prefixId);
        }
        def.setTemplateParameters(prop);
        def.setTemplateDefaultParameters(propDefaultValues);
        def.setRouteTemplateContext(routeTemplateContext);
        if (target.getTemplateBeans() != null) {
            DefaultModel.addTemplateBeans(routeTemplateContext, target);
        }
        if (target.getConfigurer() != null) {
            routeTemplateContext.setConfigurer(target.getConfigurer());
        }
        if ((string = RouteDefinitionHelper.validateUniqueIds((RouteDefinition)def, this.routeDefinitions, (String)prefixId)) != null) {
            throw new FailedToCreateRouteFromTemplateException(routeId, routeTemplateId, "duplicate id detected: " + string + ". Please correct ids to be unique among all your routes.");
        }
        RoutesDefinition routeCollection = new RoutesDefinition();
        routeCollection.setCamelContext(this.camelContext);
        routeCollection.setRoutes(this.getRouteDefinitions());
        routeCollection.prepareRoute(def);
        this.addRouteDefinition(def);
        return def.getId();
    }

    private static void addProperty(Map<String, Object> prop, String key, Object value) {
        prop.put(key, value);
        key = StringHelper.dashToCamelCase((String)key);
        prop.put(key, value);
        key = StringHelper.camelCaseToDash((String)key);
        prop.put(key, value);
    }

    private static void addTemplateBeans(RouteTemplateContext routeTemplateContext, RouteTemplateDefinition target) throws Exception {
        for (RouteTemplateBeanDefinition b : target.getTemplateBeans()) {
            DefaultModel.bind(b, routeTemplateContext);
        }
    }

    private static void bind(BeanFactoryDefinition<?, ?> beanFactory, RouteTemplateContext routeTemplateContext) throws Exception {
        HashMap props = new HashMap();
        if (beanFactory.getProperties() != null) {
            props.putAll(beanFactory.getProperties());
        }
        if (beanFactory.getPropertyDefinitions() != null) {
            beanFactory.getPropertyDefinitions().forEach(p -> props.put(p.getKey(), p.getValue()));
        }
        if (beanFactory.getBeanSupplier() != null) {
            if (props.isEmpty()) {
                if (beanFactory.getBeanClass() != null) {
                    routeTemplateContext.bind(beanFactory.getName(), beanFactory.getBeanClass(), (Object)beanFactory.getBeanSupplier());
                } else {
                    routeTemplateContext.bind(beanFactory.getName(), (Object)beanFactory.getBeanSupplier());
                }
            }
        } else if (beanFactory.getScript() != null && beanFactory.getScriptLanguage() != null) {
            ScriptingLanguage slan;
            Class clazz;
            CamelContext camelContext = routeTemplateContext.getCamelContext();
            Language lan = camelContext.resolveLanguage(beanFactory.getScriptLanguage());
            if (beanFactory.getBeanClass() != null) {
                clazz = beanFactory.getBeanClass();
            } else if (beanFactory.getType() != null) {
                String fqn = beanFactory.getType();
                if (fqn.contains(":")) {
                    fqn = StringHelper.after((String)fqn, (String)":");
                }
                clazz = camelContext.getClassResolver().resolveMandatoryClass(fqn);
            } else {
                clazz = Object.class;
            }
            String script = beanFactory.getScript();
            ScriptingLanguage scriptingLanguage = slan = lan instanceof ScriptingLanguage ? (ScriptingLanguage)lan : null;
            if (slan != null) {
                routeTemplateContext.bind(beanFactory.getName(), clazz, Suppliers.memorize(() -> {
                    HashMap<String, RouteTemplateContext> bindings = new HashMap<String, RouteTemplateContext>();
                    bindings.put("rtc", routeTemplateContext);
                    Object local = slan.evaluate(script, bindings, Object.class);
                    if (!props.isEmpty()) {
                        PropertyBindingSupport.setPropertiesOnTarget((CamelContext)camelContext, (Object)local, (Map)props);
                    }
                    return local;
                }));
            } else {
                routeTemplateContext.bind(beanFactory.getName(), clazz, Suppliers.memorize(() -> {
                    ExchangeFactory ef = camelContext.getCamelContextExtension().getExchangeFactory();
                    Exchange dummy = ef.create(false);
                    try {
                        String text = ScriptHelper.resolveOptionalExternalScript((CamelContext)camelContext, (Exchange)dummy, (String)script);
                        if (text != null) {
                            Expression exp = lan.createExpression(text);
                            Object local = exp.evaluate(dummy, clazz);
                            if (!props.isEmpty()) {
                                PropertyBindingSupport.setPropertiesOnTarget((CamelContext)camelContext, (Object)local, (Map)props);
                            }
                            Object object = local;
                            return object;
                        }
                        Object var8_9 = null;
                        return var8_9;
                    }
                    finally {
                        ef.release(dummy);
                    }
                }));
            }
        } else if (beanFactory.getBeanClass() != null || beanFactory.getType() != null && beanFactory.getType().startsWith("#class:")) {
            String className = null;
            String factoryMethod = null;
            String parameters = null;
            if (beanFactory.getType() != null) {
                className = beanFactory.getType().substring(7);
                if (className.endsWith(")") && className.indexOf(40) != -1) {
                    parameters = StringHelper.after((String)className, (String)"(");
                    parameters = parameters.substring(0, parameters.length() - 1);
                    className = StringHelper.before((String)className, (String)"(");
                }
                if (className != null && className.indexOf(35) != -1) {
                    factoryMethod = StringHelper.after((String)className, (String)"#");
                    className = StringHelper.before((String)className, (String)"#");
                }
            }
            if (className != null && (factoryMethod != null || parameters != null)) {
                String typeOrRef;
                CamelContext camelContext = routeTemplateContext.getCamelContext();
                Class clazz = camelContext.getClassResolver().resolveMandatoryClass(className);
                Class fc = null;
                if (factoryMethod != null && (typeOrRef = StringHelper.before(factoryMethod, (String)":")) != null) {
                    factoryMethod = StringHelper.after((String)factoryMethod, (String)":");
                    Object existing = camelContext.getRegistry().lookupByName(typeOrRef);
                    fc = existing != null ? existing.getClass() : camelContext.getClassResolver().resolveMandatoryClass(typeOrRef);
                }
                Class factoryClass = fc;
                String fqn = className;
                String fm = factoryMethod;
                String fp = parameters;
                routeTemplateContext.bind(beanFactory.getName(), Object.class, Suppliers.memorize(() -> {
                    String params = camelContext.resolvePropertyPlaceholders(fp);
                    try {
                        Object local;
                        if (fm != null) {
                            if (fp != null) {
                                Class target = factoryClass != null ? factoryClass : clazz;
                                local = PropertyBindingSupport.newInstanceFactoryParameters((CamelContext)camelContext, (Class)target, (String)fm, (String)params);
                            } else {
                                local = camelContext.getInjector().newInstance(clazz, factoryClass, fm);
                            }
                            if (local == null) {
                                throw new IllegalStateException("Cannot create bean instance using factory method: " + fqn + "#" + fm);
                            }
                        } else {
                            local = PropertyBindingSupport.newInstanceConstructorParameters((CamelContext)camelContext, (Class)clazz, (String)params);
                        }
                        if (!props.isEmpty()) {
                            PropertyBindingSupport.setPropertiesOnTarget((CamelContext)camelContext, (Object)local, (Map)props);
                        }
                        return local;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot create bean: " + beanFactory.getType());
                    }
                }));
            } else {
                CamelContext camelContext = routeTemplateContext.getCamelContext();
                Class clazz = beanFactory.getBeanClass() != null ? beanFactory.getBeanClass() : camelContext.getClassResolver().resolveMandatoryClass(className);
                routeTemplateContext.bind(beanFactory.getName(), clazz, Suppliers.memorize(() -> {
                    Object local = camelContext.getInjector().newInstance(clazz);
                    if (!props.isEmpty()) {
                        PropertyBindingSupport.setPropertiesOnTarget((CamelContext)camelContext, (Object)local, (Map)props);
                    }
                    return local;
                }));
            }
        } else if (beanFactory.getType() != null && beanFactory.getType().startsWith("#type:")) {
            CamelContext camelContext = routeTemplateContext.getCamelContext();
            Class clazz = camelContext.getClassResolver().resolveMandatoryClass(beanFactory.getType().substring(6));
            Object found = camelContext.getRegistry().mandatoryFindSingleByType(clazz);
            routeTemplateContext.bind(beanFactory.getName(), clazz, found);
        } else {
            throw new IllegalArgumentException("Route template local bean: " + beanFactory.getName() + " has invalid type syntax: " + beanFactory.getType() + ". To refer to a class then prefix the value with #class such as: #class:fullyQualifiedClassName");
        }
    }

    public void addRouteFromTemplatedRoute(TemplatedRouteDefinition templatedRouteDefinition) throws Exception {
        List beans;
        ObjectHelper.notNull((Object)templatedRouteDefinition, (String)"templatedRouteDefinition");
        DefaultRouteTemplateContext routeTemplateContext = new DefaultRouteTemplateContext(this.camelContext);
        List parameters = templatedRouteDefinition.getParameters();
        if (parameters != null) {
            for (TemplatedRouteParameterDefinition parameterDefinition : parameters) {
                routeTemplateContext.setParameter(parameterDefinition.getName(), (Object)parameterDefinition.getValue());
            }
        }
        if ((beans = templatedRouteDefinition.getBeans()) != null) {
            for (TemplatedRouteBeanDefinition beanDefinition : beans) {
                DefaultModel.bind(beanDefinition, (RouteTemplateContext)routeTemplateContext);
            }
        }
        this.addRouteFromTemplate(templatedRouteDefinition.getRouteId(), templatedRouteDefinition.getRouteTemplateRef(), templatedRouteDefinition.getPrefixId(), (RouteTemplateContext)routeTemplateContext);
    }

    public synchronized List<RestDefinition> getRestDefinitions() {
        return this.restDefinitions;
    }

    public synchronized void addRestDefinitions(Collection<RestDefinition> restDefinitions, boolean addToRoutes) throws Exception {
        if (restDefinitions == null || restDefinitions.isEmpty()) {
            return;
        }
        this.restDefinitions.addAll(restDefinitions);
        if (addToRoutes) {
            for (RestDefinition restDefinition : restDefinitions) {
                List routeDefinitions = restDefinition.asRouteDefinition(this.camelContext);
                this.addRouteDefinitions(routeDefinitions);
            }
        }
    }

    public ServiceCallConfigurationDefinition getServiceCallConfiguration(String serviceName) {
        if (serviceName == null) {
            serviceName = "";
        }
        return this.serviceCallConfigurations.get(serviceName);
    }

    public void setServiceCallConfiguration(ServiceCallConfigurationDefinition configuration) {
        this.serviceCallConfigurations.put("", configuration);
    }

    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (ServiceCallConfigurationDefinition configuration : configurations) {
                this.serviceCallConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    public void addServiceCallConfiguration(String serviceName, ServiceCallConfigurationDefinition configuration) {
        this.serviceCallConfigurations.put(serviceName, configuration);
    }

    public Resilience4jConfigurationDefinition getResilience4jConfiguration(String id) {
        if (id == null) {
            id = "";
        }
        return this.resilience4jConfigurations.get(id);
    }

    public void setResilience4jConfiguration(Resilience4jConfigurationDefinition configuration) {
        this.resilience4jConfigurations.put("", configuration);
    }

    public void setResilience4jConfigurations(List<Resilience4jConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (Resilience4jConfigurationDefinition configuration : configurations) {
                this.resilience4jConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    public void addResilience4jConfiguration(String id, Resilience4jConfigurationDefinition configuration) {
        this.resilience4jConfigurations.put(id, configuration);
    }

    public FaultToleranceConfigurationDefinition getFaultToleranceConfiguration(String id) {
        if (id == null) {
            id = "";
        }
        return this.faultToleranceConfigurations.get(id);
    }

    public void setFaultToleranceConfiguration(FaultToleranceConfigurationDefinition configuration) {
        this.faultToleranceConfigurations.put("", configuration);
    }

    public void setFaultToleranceConfigurations(List<FaultToleranceConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (FaultToleranceConfigurationDefinition configuration : configurations) {
                this.faultToleranceConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    public void addFaultToleranceConfiguration(String id, FaultToleranceConfigurationDefinition configuration) {
        this.faultToleranceConfigurations.put(id, configuration);
    }

    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        DataFormatDefinition type = DefaultModel.lookup(this.camelContext, name, DataFormatDefinition.class);
        if (type == null && this.getDataFormats() != null) {
            type = this.getDataFormats().get(name);
        }
        return type;
    }

    public ProcessorDefinition<?> getProcessorDefinition(String id) {
        for (RouteDefinition route : this.getRouteDefinitions()) {
            Collection col = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), ProcessorDefinition.class);
            for (ProcessorDefinition proc : col) {
                Object pid = proc.getId();
                if (id.equals(pid)) {
                    return proc;
                }
                if (proc.getNodePrefixId() == null || !id.equals(pid = proc.getNodePrefixId() + (String)pid)) continue;
                return proc;
            }
        }
        return null;
    }

    public <T extends ProcessorDefinition<T>> T getProcessorDefinition(String id, Class<T> type) {
        ProcessorDefinition<?> answer = this.getProcessorDefinition(id);
        if (answer != null) {
            return (T)((ProcessorDefinition)type.cast(answer));
        }
        return null;
    }

    public Map<String, DataFormatDefinition> getDataFormats() {
        return this.dataFormats;
    }

    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        this.dataFormats = dataFormats;
    }

    public List<TransformerDefinition> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<TransformerDefinition> transformers) {
        this.transformers = transformers;
    }

    public List<ValidatorDefinition> getValidators() {
        return this.validators;
    }

    public void setValidators(List<ValidatorDefinition> validators) {
        this.validators = validators;
    }

    public void setRouteFilterPattern(String include, String exclude) {
        this.setRouteFilter(RouteFilters.filterByPattern((String)include, (String)exclude));
    }

    public Function<RouteDefinition, Boolean> getRouteFilter() {
        return this.routeFilter;
    }

    public void setRouteFilter(Function<RouteDefinition, Boolean> routeFilter) {
        this.routeFilter = routeFilter;
    }

    public ModelReifierFactory getModelReifierFactory() {
        return this.modelReifierFactory;
    }

    public void setModelReifierFactory(ModelReifierFactory modelReifierFactory) {
        this.modelReifierFactory = modelReifierFactory;
    }

    public void addRegistryBean(RegistryBeanDefinition bean) {
        this.beans.removeIf(b -> bean.getName().equals(b.getName()));
        this.beans.add(bean);
    }

    public List<RegistryBeanDefinition> getRegistryBeans() {
        return this.beans;
    }

    protected boolean shouldStartRoutes() {
        return this.camelContext.isStarted() && !this.camelContext.isStarting();
    }

    private static <T> T lookup(CamelContext context, String ref, Class<T> type) {
        try {
            return (T)context.getRegistry().lookupByNameAndType(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean includedRouteConfiguration(RouteConfigurationDefinition definition) {
        return PreconditionHelper.included((PreconditionContainer)definition, this.camelContext);
    }
}

