/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.ref;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.PredicateToExpressionAdapter;
import org.apache.camel.support.builder.ExpressionBuilder;

@Language(value="ref")
public class RefLanguage
extends LanguageSupport {
    public Predicate createPredicate(String expression) {
        if (RefLanguage.hasSimpleFunction((String)expression)) {
            return this.createDynamic(expression);
        }
        return this.createStaticPredicate(expression);
    }

    public Expression createExpression(String expression) {
        if (RefLanguage.hasSimpleFunction((String)expression)) {
            return this.createDynamic(expression);
        }
        return this.createStaticExpression(expression);
    }

    protected Expression createStaticExpression(String expression) {
        Expression answer;
        Object exp = this.getCamelContext().getRegistry().lookupByName(expression);
        if (exp instanceof Expression) {
            answer = (Expression)exp;
        } else if (exp instanceof Predicate) {
            answer = PredicateToExpressionAdapter.toExpression((Predicate)((Predicate)exp));
        } else {
            throw new IllegalArgumentException("Cannot find expression or predicate in registry with ref: " + expression);
        }
        answer.init(this.getCamelContext());
        return answer;
    }

    protected Predicate createStaticPredicate(String expression) {
        Predicate answer;
        Object exp = this.getCamelContext().getRegistry().lookupByName(expression);
        if (exp instanceof Expression) {
            answer = ExpressionToPredicateAdapter.toPredicate((Expression)((Expression)exp));
        } else if (exp instanceof Predicate) {
            answer = (Predicate)exp;
        } else {
            throw new IllegalArgumentException("Cannot find expression or predicate in registry with ref: " + expression);
        }
        answer.init(this.getCamelContext());
        return answer;
    }

    protected ExpressionAdapter createDynamic(final String expression) {
        ExpressionAdapter answer = new ExpressionAdapter(){
            private Expression exp;
            private Registry registry;

            public void init(CamelContext context) {
                this.registry = context.getRegistry();
                this.exp = ExpressionBuilder.simpleExpression((String)expression);
                this.exp.init(context);
            }

            public Object evaluate(Exchange exchange) {
                Object lookup;
                Expression target = null;
                String ref = (String)this.exp.evaluate(exchange, String.class);
                Object object = lookup = ref != null ? this.registry.lookupByName(ref) : null;
                if (lookup instanceof Expression) {
                    target = (Expression)lookup;
                } else if (lookup instanceof Predicate) {
                    target = PredicateToExpressionAdapter.toExpression((Predicate)((Predicate)lookup));
                }
                if (target != null) {
                    return target.evaluate(exchange, Object.class);
                }
                throw new IllegalArgumentException("Cannot find expression or predicate in registry with ref: " + ref);
            }

            public String toString() {
                return "ref:" + this.exp.toString();
            }
        };
        answer.init(this.getCamelContext());
        return answer;
    }
}

