/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.language.simple.SimpleTokenizer;
import org.apache.camel.language.simple.ast.Block;
import org.apache.camel.language.simple.ast.BlockEnd;
import org.apache.camel.language.simple.ast.BlockStart;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.ast.UnaryExpression;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.language.simple.types.SimpleTokenType;
import org.apache.camel.language.simple.types.TokenType;

public abstract class BaseSimpleParser {
    protected final CamelContext camelContext;
    protected final String expression;
    protected final List<SimpleToken> tokens = new ArrayList<SimpleToken>();
    protected final List<SimpleNode> nodes = new ArrayList<SimpleNode>();
    protected SimpleToken token;
    protected int previousIndex;
    protected int index;
    protected final boolean allowEscape;

    protected BaseSimpleParser(CamelContext camelContext, String expression, boolean allowEscape) {
        this.camelContext = camelContext;
        this.expression = expression;
        this.allowEscape = allowEscape;
    }

    protected void nextToken() {
        if (this.index < this.expression.length()) {
            SimpleToken next = SimpleTokenizer.nextToken(this.expression, this.index, this.allowEscape);
            this.tokens.add(next);
            this.token = next;
            this.previousIndex = this.index;
            this.index += next.getLength();
        } else {
            this.token = new SimpleToken(new SimpleTokenType(TokenType.eol, null), this.index);
        }
    }

    protected void nextToken(TokenType ... filter) {
        if (this.index < this.expression.length()) {
            SimpleToken next = SimpleTokenizer.nextToken(this.expression, this.index, this.allowEscape, filter);
            this.tokens.add(next);
            this.token = next;
            this.previousIndex = this.index;
            this.index += next.getLength();
        } else {
            this.token = new SimpleToken(new SimpleTokenType(TokenType.eol, null), this.index);
        }
    }

    protected void clear() {
        this.token = null;
        this.previousIndex = 0;
        this.index = 0;
        this.tokens.clear();
        this.nodes.clear();
    }

    protected void prepareBlocks() {
        ArrayList<SimpleNode> answer = new ArrayList<SimpleNode>();
        ArrayDeque<Block> stack = new ArrayDeque<Block>();
        for (SimpleNode token : this.nodes) {
            if (token instanceof BlockStart) {
                stack.push((Block)token);
                continue;
            }
            if (token instanceof BlockEnd) {
                if (stack.isEmpty()) {
                    throw new SimpleParserException(token.getToken().getType().getType() + " has no matching start token", token.getToken().getIndex());
                }
                Block top = (Block)stack.pop();
                BaseSimpleParser.acceptOrAdd(answer, stack, top);
                continue;
            }
            BaseSimpleParser.acceptOrAdd(answer, stack, token);
        }
        this.nodes.clear();
        this.nodes.addAll(answer);
    }

    private static void acceptOrAdd(List<SimpleNode> answer, Deque<Block> stack, SimpleNode token) {
        Block block;
        Block block2 = block = stack.isEmpty() ? null : stack.peek();
        if (block != null) {
            if (!block.acceptAndAddNode(token)) {
                throw new SimpleParserException(block.getToken().getType() + " cannot accept " + token.getToken().getType(), token.getToken().getIndex());
            }
        } else {
            answer.add(token);
        }
    }

    protected void prepareUnaryExpressions() {
        ArrayDeque<SimpleNode> stack = new ArrayDeque<SimpleNode>();
        for (SimpleNode node : this.nodes) {
            if (node instanceof UnaryExpression) {
                SimpleNode previous;
                UnaryExpression token = (UnaryExpression)node;
                String operator = token.getOperator().toString();
                SimpleNode simpleNode = previous = stack.isEmpty() ? null : (SimpleNode)stack.pop();
                if (previous == null) {
                    throw new SimpleParserException("Unary operator " + operator + " has no left hand side token", token.getToken().getIndex());
                }
                token.acceptLeft(previous);
            }
            stack.push(node);
        }
        this.nodes.clear();
        this.nodes.addAll(stack);
        Collections.reverse(this.nodes);
    }

    protected boolean accept(TokenType accept) {
        return this.token == null || this.token.getType().getType() == accept;
    }

    protected void expect(TokenType expect) throws SimpleParserException {
        if (this.token != null && this.token.getType().getType() == expect) {
            return;
        }
        if (this.token == null) {
            throw new SimpleParserException("expected symbol " + expect + " but reached eol", this.previousIndex);
        }
        throw new SimpleParserException("expected symbol " + expect + " but was " + this.token.getType().getType(), this.previousIndex);
    }

    protected void expectAndAcceptMore(TokenType expect) {
        this.expect(expect);
        while (!this.token.getType().isEol() && this.token.getType().getType() == expect) {
            this.nextToken();
        }
    }
}

