/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.csimple;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.language.csimple.CSimpleExpressionParser;
import org.apache.camel.language.csimple.CSimpleGeneratedCode;
import org.apache.camel.language.csimple.CSimplePredicateParser;
import org.apache.camel.util.StringHelper;

public class CSimpleCodeGenerator {
    private static final AtomicInteger UUID = new AtomicInteger();
    private Set<String> imports = new TreeSet<String>();
    private Map<String, String> aliases = new HashMap<String, String>();

    public Set<String> getImports() {
        return this.imports;
    }

    public void setImports(Set<String> imports) {
        this.imports = imports;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public CSimpleGeneratedCode generateExpression(String fqn, String script) {
        return this.generateCode(fqn, script, false);
    }

    public CSimpleGeneratedCode generatePredicate(String fqn, String script) {
        return this.generateCode(fqn, script, true);
    }

    private CSimpleGeneratedCode generateCode(String fqn, String script, boolean predicate) {
        String text = script;
        text = text.replaceAll("\n", "");
        text = text.trim();
        String qn = fqn.substring(0, fqn.lastIndexOf(46));
        String name = CSimpleCodeGenerator.nextName();
        script = ((String)script).trim();
        script = this.alias((String)script);
        StringBuilder sb = new StringBuilder(4096);
        sb.append("package ").append(qn).append(";\n");
        sb.append("\n");
        sb.append("import java.util.*;\n");
        sb.append("import java.util.concurrent.*;\n");
        sb.append("import java.util.stream.*;\n");
        sb.append("\n");
        sb.append("import org.apache.camel.*;\n");
        sb.append("import org.apache.camel.util.*;\n");
        sb.append("import org.apache.camel.spi.*;\n");
        sb.append("import static org.apache.camel.language.csimple.CSimpleHelper.*;\n");
        sb.append("\n");
        for (String i : this.imports) {
            sb.append(i);
            if (!i.endsWith(";")) {
                sb.append(";");
            }
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("public class ").append(name).append(" extends org.apache.camel.language.csimple.CSimpleSupport {\n");
        sb.append("\n");
        sb.append("    Language bean;\n");
        sb.append("    UuidGenerator uuid;\n");
        sb.append("\n");
        sb.append("    public ").append(name).append("() {\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    @Override\n");
        sb.append("    public boolean isPredicate() {\n");
        sb.append("        return ").append(predicate).append(";\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    @Override\n");
        sb.append("    public String getText() {\n");
        String escaped = text.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        sb.append("        return \"").append(escaped).append("\";\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    @Override\n");
        sb.append("    public Object evaluate(CamelContext context, Exchange exchange, Message message, Object body) throws Exception {\n");
        sb.append("        ");
        if (predicate) {
            parser = new CSimplePredicateParser();
            if (((String)(script = ((CSimplePredicateParser)parser).parsePredicate((String)script))).isBlank()) {
                script = "false";
            }
        } else {
            parser = new CSimpleExpressionParser();
            if (((String)(script = ((CSimpleExpressionParser)parser).parseExpression((String)script))).isBlank()) {
                script = "\"" + (String)script + "\"";
            }
        }
        String uuid = null;
        if (((String)script).startsWith("    UuidGenerator uuid")) {
            uuid = StringHelper.before((String)script, (String)"\n") + "\n";
            script = StringHelper.after((String)script, (String)"\n");
        }
        if (!((String)script).contains("return ")) {
            sb.append("return ");
        }
        sb.append((String)script);
        if (!((String)script).endsWith("}") && !((String)script).endsWith(";")) {
            sb.append(";");
        }
        sb.append("\n");
        sb.append("    }\n");
        if (((String)script).contains("bean(exchange, bean,")) {
            sb.append("\n");
            sb.append("    @Override\n");
            sb.append("    public void init(CamelContext context) {\n");
            sb.append("        bean = context.resolveLanguage(\"bean\");\n");
            sb.append("    }\n");
            sb.append("\n");
        }
        sb.append("}\n");
        sb.append("\n");
        String code = sb.toString();
        if (uuid != null) {
            code = code.replace("    UuidGenerator uuid;\n", uuid);
        }
        return new CSimpleGeneratedCode(qn + "." + name, code);
    }

    private String alias(String script) {
        for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            script = script.replace(key, value);
        }
        return script;
    }

    private static String nextName() {
        return "CSimpleScript" + UUID.incrementAndGet();
    }
}

