/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateScriptDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="templateBean")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouteTemplateBeanDefinition {
    @XmlTransient
    private RouteTemplateDefinition parent;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=true)
    private String type;
    @XmlAttribute
    private String beanType;
    @XmlElement(name="property")
    private List<PropertyDefinition> properties;
    @XmlElement(name="script")
    private RouteTemplateScriptDefinition script;
    @XmlTransient
    private Class<?> beanClass;
    @XmlTransient
    private RouteTemplateContext.BeanSupplier<Object> beanSupplier;

    void setParent(RouteTemplateDefinition parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public void setBeanType(String beanType) {
        this.beanType = beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanClass = beanType;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public List<PropertyDefinition> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyDefinition> properties) {
        this.properties = properties;
    }

    public RouteTemplateContext.BeanSupplier<Object> getBeanSupplier() {
        return this.beanSupplier;
    }

    public void setBeanSupplier(RouteTemplateContext.BeanSupplier<Object> beanSupplier) {
        this.beanSupplier = beanSupplier;
    }

    public RouteTemplateScriptDefinition getScript() {
        return this.script;
    }

    public void setScript(RouteTemplateScriptDefinition script) {
        this.script = script;
    }

    public void setScript(String script) {
        this.script = new RouteTemplateScriptDefinition();
        this.script.setScript(script);
    }

    public RouteTemplateBeanDefinition type(String prefix, Class<?> type) {
        if (((String)prefix).startsWith("#type") || ((String)prefix).startsWith("#class")) {
            if (!((String)prefix).endsWith(":")) {
                prefix = (String)prefix + ":";
            }
            this.setType((String)prefix + type.getName());
        } else {
            this.setType((String)prefix);
        }
        this.setBeanType(type);
        return this;
    }

    public RouteTemplateBeanDefinition type(String type) {
        if (!((String)type).startsWith("#")) {
            type = "#class:" + (String)type;
        }
        this.setType((String)type);
        return this;
    }

    public RouteTemplateBeanDefinition typeClass(Class<?> type) {
        this.setType("#class:" + type.getName());
        return this;
    }

    public RouteTemplateBeanDefinition typeClass(String type) {
        this.setType("#class:" + type);
        return this;
    }

    public RouteTemplateBeanDefinition beanType(Class<?> type) {
        this.setBeanType(type);
        return this;
    }

    public RouteTemplateBeanDefinition beanType(String type) {
        this.setBeanType(type);
        return this;
    }

    public RouteTemplateDefinition bean(Class<?> type) {
        return this.bean(type, null);
    }

    public RouteTemplateDefinition bean(Class<?> type, String method) {
        this.setType("bean");
        if (method != null) {
            this.setScript(type.getName() + "?method=" + method);
        } else {
            this.setScript(type.getName());
        }
        return this.parent;
    }

    public RouteTemplateDefinition groovy(String script) {
        this.setType("groovy");
        this.setScript(script);
        return this.parent;
    }

    public RouteTemplateDefinition joor(String script) {
        this.setType("joor");
        this.setScript(script);
        return this.parent;
    }

    public RouteTemplateDefinition language(String language, String script) {
        this.setType(language);
        this.setScript(script);
        return this.parent;
    }

    public RouteTemplateDefinition mvel(String script) {
        this.setType("mvel");
        this.setScript(script);
        return this.parent;
    }

    public RouteTemplateDefinition ognl(String script) {
        this.setType("ognl");
        this.setScript(script);
        return this.parent;
    }

    public RouteTemplateBeanDefinition property(String key, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyDefinition>();
        }
        this.properties.add(new PropertyDefinition(key, value));
        return this;
    }

    public RouteTemplateBeanDefinition properties(Map<String, String> properties) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyDefinition>();
        }
        properties.forEach((k, v) -> this.properties.add(new PropertyDefinition((String)k, (String)v)));
        return this;
    }

    public RouteTemplateDefinition end() {
        return this.parent;
    }
}

