/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OutputExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="split")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SplitDefinition
extends OutputExpressionNode
implements ExecutorServiceAwareDefinition<SplitDefinition> {
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    @Metadata(defaultValue=",")
    private String delimiter;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String parallelProcessing;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private String strategyMethodName;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String strategyMethodAllowNull;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String streaming;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String stopOnException;
    @XmlAttribute
    @Metadata(defaultValue="0", javaType="java.time.Duration")
    private String timeout;
    @XmlAttribute
    private String onPrepareRef;
    @XmlTransient
    private Processor onPrepare;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String shareUnitOfWork;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String parallelAggregate;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", deprecationNote="Has no effect in Camel 3.x")
    @Deprecated
    private String stopOnAggregateException;

    public SplitDefinition() {
    }

    public SplitDefinition(Expression expression) {
        super(expression);
    }

    public SplitDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public String toString() {
        return "Split[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    public String getShortName() {
        return "split";
    }

    @Override
    public String getLabel() {
        return "split[" + this.getExpression() + "]";
    }

    public SplitDefinition delimiter(String delimiter) {
        this.setDelimiter(delimiter);
        return this;
    }

    public SplitDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public SplitDefinition aggregationStrategy(Supplier<AggregationStrategy> aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy.get());
        return this;
    }

    public SplitDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setStrategyRef(aggregationStrategyRef);
        return this;
    }

    public SplitDefinition aggregationStrategyMethodName(String methodName) {
        this.setStrategyMethodName(methodName);
        return this;
    }

    public SplitDefinition aggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull(true);
    }

    public SplitDefinition aggregationStrategyMethodAllowNull(boolean aggregationStrategyMethodAllowNull) {
        return this.aggregationStrategyMethodAllowNull(Boolean.toString(aggregationStrategyMethodAllowNull));
    }

    public SplitDefinition aggregationStrategyMethodAllowNull(String aggregationStrategyMethodAllowNull) {
        this.setStrategyMethodAllowNull(aggregationStrategyMethodAllowNull);
        return this;
    }

    public SplitDefinition parallelProcessing() {
        return this.parallelProcessing(true);
    }

    public SplitDefinition parallelProcessing(boolean parallelProcessing) {
        return this.parallelProcessing(Boolean.toString(parallelProcessing));
    }

    public SplitDefinition parallelProcessing(String parallelProcessing) {
        this.setParallelProcessing(parallelProcessing);
        return this;
    }

    public SplitDefinition parallelAggregate() {
        return this.parallelAggregate(true);
    }

    public SplitDefinition parallelAggregate(boolean parallelAggregate) {
        return this.parallelAggregate(Boolean.toString(parallelAggregate));
    }

    public SplitDefinition parallelAggregate(String parallelAggregate) {
        this.setParallelAggregate(parallelAggregate);
        return this;
    }

    @Deprecated
    public SplitDefinition stopOnAggregateException() {
        return this.stopOnAggregateException(true);
    }

    @Deprecated
    public SplitDefinition stopOnAggregateException(boolean stopOnAggregateException) {
        return this.stopOnAggregateException(Boolean.toString(stopOnAggregateException));
    }

    public SplitDefinition stopOnAggregateException(String stopOnAggregateException) {
        this.setStopOnAggregateException(stopOnAggregateException);
        return this;
    }

    public SplitDefinition streaming() {
        return this.streaming(true);
    }

    public SplitDefinition streaming(boolean streaming) {
        return this.streaming(Boolean.toString(streaming));
    }

    public SplitDefinition streaming(String streaming) {
        this.setStreaming(streaming);
        return this;
    }

    public SplitDefinition stopOnException() {
        return this.stopOnException(true);
    }

    public SplitDefinition stopOnException(boolean stopOnException) {
        return this.stopOnException(Boolean.toString(stopOnException));
    }

    public SplitDefinition stopOnException(String stopOnException) {
        this.setStopOnException(stopOnException);
        return this;
    }

    @Override
    public SplitDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public SplitDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public SplitDefinition onPrepare(Processor onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public SplitDefinition onPrepareRef(String onPrepareRef) {
        this.setOnPrepareRef(onPrepareRef);
        return this;
    }

    public SplitDefinition timeout(long timeout) {
        return this.timeout(Long.toString(timeout));
    }

    public SplitDefinition timeout(String timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public SplitDefinition shareUnitOfWork() {
        return this.shareUnitOfWork(true);
    }

    public SplitDefinition shareUnitOfWork(boolean shareUnitOfWork) {
        return this.shareUnitOfWork(Boolean.toString(shareUnitOfWork));
    }

    public SplitDefinition shareUnitOfWork(String shareUnitOfWork) {
        this.setShareUnitOfWork(shareUnitOfWork);
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(String parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public String getStreaming() {
        return this.streaming;
    }

    public void setStreaming(String streaming) {
        this.streaming = streaming;
    }

    public String getParallelAggregate() {
        return this.parallelAggregate;
    }

    public void setParallelAggregate(String parallelAggregate) {
        this.parallelAggregate = parallelAggregate;
    }

    @Deprecated
    public String getStopOnAggregateException() {
        return this.stopOnAggregateException;
    }

    @Deprecated
    public void setStopOnAggregateException(String stopOnAggregateException) {
        this.stopOnAggregateException = stopOnAggregateException;
    }

    public String getStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(String stopOnException) {
        this.stopOnException = stopOnException;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public String getStrategyMethodName() {
        return this.strategyMethodName;
    }

    public void setStrategyMethodName(String strategyMethodName) {
        this.strategyMethodName = strategyMethodName;
    }

    public String getStrategyMethodAllowNull() {
        return this.strategyMethodAllowNull;
    }

    public void setStrategyMethodAllowNull(String strategyMethodAllowNull) {
        this.strategyMethodAllowNull = strategyMethodAllowNull;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getOnPrepareRef() {
        return this.onPrepareRef;
    }

    public void setOnPrepareRef(String onPrepareRef) {
        this.onPrepareRef = onPrepareRef;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public String getShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(String shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }
}

