/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NamedNode;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.NodeIdFactory;

@XmlType(name="optionalIdentifiedDefinition")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public abstract class OptionalIdentifiedDefinition<T extends OptionalIdentifiedDefinition<T>>
implements NamedNode,
IdAware,
CamelContextAware {
    private CamelContext camelContext;
    private String id;
    private Boolean customId;
    private DescriptionDefinition description;
    private transient int lineNumber = -1;
    private transient String location;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @XmlTransient
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    @XmlAttribute
    @Metadata(description="The id of this node")
    public void setId(String id) {
        this.id = id;
        this.customId = true;
    }

    public void setGeneratedId(String id) {
        this.id = id;
        this.customId = null;
    }

    public DescriptionDefinition getDescription() {
        return this.description;
    }

    @XmlElement
    @Metadata(description="The description for this node")
    public void setDescription(DescriptionDefinition description) {
        this.description = description;
    }

    public NamedNode getParent() {
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @XmlTransient
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getLocation() {
        return this.location;
    }

    @XmlTransient
    public void setLocation(String location) {
        this.location = location;
    }

    public T description(String text) {
        if (text != null) {
            if (this.description == null) {
                this.description = new DescriptionDefinition();
            }
            this.description.setText(text);
        }
        return (T)this;
    }

    @Deprecated
    public T description(String id, String text, String lang) {
        if (id != null) {
            this.setId(id);
        }
        if (text != null) {
            if (this.description == null) {
                this.description = new DescriptionDefinition();
            }
            this.description.setText(text);
        }
        if (lang != null) {
            if (this.description == null) {
                this.description = new DescriptionDefinition();
            }
            this.description.setLang(lang);
        }
        return (T)this;
    }

    public T id(String id) {
        this.setId(id);
        return (T)this;
    }

    public String idOrCreate(NodeIdFactory factory) {
        if (this.id == null) {
            this.setGeneratedId(factory.createId((NamedNode)this));
        }
        return this.id;
    }

    public Boolean getCustomId() {
        return this.customId;
    }

    @XmlAttribute
    public void setCustomId(Boolean customId) {
        this.customId = customId;
    }

    public boolean hasCustomIdAssigned() {
        return this.customId != null && this.customId != false;
    }

    public String getDescriptionText() {
        return this.description != null ? this.description.getText() : null;
    }
}

