/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.NamespaceAware;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class NamespaceAwareExpression
extends ExpressionDefinition
implements NamespaceAware {
    @XmlElement(name="namespace")
    @Metadata(label="common")
    private List<PropertyDefinition> namespace;
    @XmlTransient
    private Map<String, String> namespaces;

    public NamespaceAwareExpression() {
    }

    public NamespaceAwareExpression(String expression) {
        super(expression);
    }

    public Map<String, String> getNamespaces() {
        return this.getNamespaceAsMap();
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public List<PropertyDefinition> getNamespace() {
        return this.namespace;
    }

    public void setNamespace(List<PropertyDefinition> namespace) {
        this.namespace = namespace;
    }

    public Map<String, String> getNamespaceAsMap() {
        if (this.namespaces == null && this.namespace != null) {
            this.namespaces = new HashMap<String, String>();
        }
        if (this.namespace != null) {
            for (PropertyDefinition def : this.namespace) {
                this.namespaces.put(def.getKey(), def.getValue());
            }
        }
        return this.namespaces;
    }
}

