/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.errorhandler;

import java.util.concurrent.ScheduledExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.errorhandler.BaseErrorHandlerDefinition;
import org.apache.camel.processor.errorhandler.DefaultErrorHandler;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="configuration,error")
@XmlRootElement(name="defaultErrorHandler")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DefaultErrorHandlerDefinition
extends BaseErrorHandlerDefinition {
    @XmlTransient
    private CamelLogger loggerBean;
    @XmlTransient
    private Processor onRedeliveryProcessor;
    @XmlTransient
    private Processor onPrepareFailureProcessor;
    @XmlTransient
    private Processor onExceptionOccurredProcessor;
    @XmlTransient
    private ScheduledExecutorService executorServiceBean;
    @XmlTransient
    private Predicate retryWhilePredicate;
    @XmlAttribute
    @Metadata(label="advanced")
    private String loggerRef;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.LoggingLevel", defaultValue="ERROR", enums="TRACE,DEBUG,INFO,WARN,ERROR,OFF")
    private String level;
    @XmlAttribute
    @Metadata(label="advanced")
    private String logName;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String useOriginalMessage;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String useOriginalBody;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.Processor")
    private String onRedeliveryRef;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.Processor")
    private String onExceptionOccurredRef;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.Processor")
    private String onPrepareFailureRef;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.Processor")
    private String retryWhileRef;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.processor.errorhandler.RedeliveryPolicy")
    private String redeliveryPolicyRef;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ScheduledExecutorService")
    private String executorServiceRef;
    @XmlElement
    private RedeliveryPolicyDefinition redeliveryPolicy;

    public boolean supportTransacted() {
        return false;
    }

    public ErrorHandlerFactory cloneBuilder() {
        DefaultErrorHandlerDefinition answer = new DefaultErrorHandlerDefinition();
        this.cloneBuilder(answer);
        return answer;
    }

    protected void cloneBuilder(DefaultErrorHandlerDefinition other) {
        other.setExecutorServiceBean(this.getExecutorServiceBean());
        other.setExecutorServiceRef(this.getExecutorServiceRef());
        other.setLevel(this.getLevel());
        other.setLogName(this.getLogName());
        other.setLoggerBean(this.getLoggerBean());
        other.setLoggerRef(this.getLoggerRef());
        other.setOnExceptionOccurredProcessor(this.getOnExceptionOccurredProcessor());
        other.setOnExceptionOccurredRef(this.getOnExceptionOccurredRef());
        other.setOnPrepareFailureProcessor(this.getOnPrepareFailureProcessor());
        other.setOnPrepareFailureRef(this.getOnPrepareFailureRef());
        other.setOnRedeliveryProcessor(this.getOnRedeliveryProcessor());
        other.setOnRedeliveryRef(this.getOnRedeliveryRef());
        other.setRedeliveryPolicyRef(this.getRedeliveryPolicyRef());
        other.setRetryWhilePredicate(this.getRetryWhilePredicate());
        other.setRetryWhileRef(this.getRetryWhileRef());
        other.setUseOriginalBody(this.getUseOriginalBody());
        other.setUseOriginalMessage(this.getUseOriginalMessage());
        if (this.hasRedeliveryPolicy()) {
            other.setRedeliveryPolicy(this.getRedeliveryPolicy().copy());
        }
    }

    protected RedeliveryPolicyDefinition createRedeliveryPolicy() {
        return new RedeliveryPolicyDefinition();
    }

    public String getLoggerRef() {
        return this.loggerRef;
    }

    public void setLoggerRef(String loggerRef) {
        this.loggerRef = loggerRef;
    }

    public CamelLogger getLoggerBean() {
        return this.loggerBean;
    }

    public void setLoggerBean(CamelLogger loggerBean) {
        this.loggerBean = loggerBean;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public String getUseOriginalMessage() {
        return this.useOriginalMessage;
    }

    public void setUseOriginalMessage(String useOriginalMessage) {
        this.useOriginalMessage = useOriginalMessage;
    }

    public String getUseOriginalBody() {
        return this.useOriginalBody;
    }

    public void setUseOriginalBody(String useOriginalBody) {
        this.useOriginalBody = useOriginalBody;
    }

    public String getOnRedeliveryRef() {
        return this.onRedeliveryRef;
    }

    public void setOnRedeliveryRef(String onRedeliveryRef) {
        this.onRedeliveryRef = onRedeliveryRef;
    }

    public Processor getOnRedeliveryProcessor() {
        return this.onRedeliveryProcessor;
    }

    public void setOnRedeliveryProcessor(Processor onRedeliveryProcessor) {
        this.onRedeliveryProcessor = onRedeliveryProcessor;
    }

    public String getOnExceptionOccurredRef() {
        return this.onExceptionOccurredRef;
    }

    public void setOnExceptionOccurredRef(String onExceptionOccurredRef) {
        this.onExceptionOccurredRef = onExceptionOccurredRef;
    }

    public Processor getOnExceptionOccurredProcessor() {
        return this.onExceptionOccurredProcessor;
    }

    public void setOnExceptionOccurredProcessor(Processor onExceptionOccurredProcessor) {
        this.onExceptionOccurredProcessor = onExceptionOccurredProcessor;
    }

    public String getOnPrepareFailureRef() {
        return this.onPrepareFailureRef;
    }

    public void setOnPrepareFailureRef(String onPrepareFailureRef) {
        this.onPrepareFailureRef = onPrepareFailureRef;
    }

    public Processor getOnPrepareFailureProcessor() {
        return this.onPrepareFailureProcessor;
    }

    public void setOnPrepareFailureProcessor(Processor onPrepareFailureProcessor) {
        this.onPrepareFailureProcessor = onPrepareFailureProcessor;
    }

    public String getRetryWhileRef() {
        return this.retryWhileRef;
    }

    public void setRetryWhileRef(String retryWhileRef) {
        this.retryWhileRef = retryWhileRef;
    }

    public String getRedeliveryPolicyRef() {
        return this.redeliveryPolicyRef;
    }

    public void setRedeliveryPolicyRef(String redeliveryPolicyRef) {
        this.redeliveryPolicyRef = redeliveryPolicyRef;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public ScheduledExecutorService getExecutorServiceBean() {
        return this.executorServiceBean;
    }

    public void setExecutorServiceBean(ScheduledExecutorService executorServiceBean) {
        this.executorServiceBean = executorServiceBean;
    }

    public Predicate getRetryWhilePredicate() {
        return this.retryWhilePredicate;
    }

    public void setRetryWhilePredicate(Predicate retryWhilePredicate) {
        this.retryWhilePredicate = retryWhilePredicate;
    }

    public RedeliveryPolicyDefinition getRedeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = this.createRedeliveryPolicy();
        }
        return this.redeliveryPolicy;
    }

    public boolean hasRedeliveryPolicy() {
        return this.redeliveryPolicy != null;
    }

    public void setRedeliveryPolicy(RedeliveryPolicyDefinition redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public DefaultErrorHandlerDefinition backOffMultiplier(double backOffMultiplier) {
        this.getRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public DefaultErrorHandlerDefinition collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.getRedeliveryPolicy().collisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public DefaultErrorHandlerDefinition redeliveryDelay(long delay) {
        this.getRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public DefaultErrorHandlerDefinition delayPattern(String delayPattern) {
        this.getRedeliveryPolicy().delayPattern(delayPattern);
        return this;
    }

    public DefaultErrorHandlerDefinition maximumRedeliveries(int maximumRedeliveries) {
        this.getRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public DefaultErrorHandlerDefinition disableRedelivery() {
        this.getRedeliveryPolicy().maximumRedeliveries(0);
        return this;
    }

    public DefaultErrorHandlerDefinition maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.getRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public DefaultErrorHandlerDefinition useCollisionAvoidance() {
        this.getRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public DefaultErrorHandlerDefinition useExponentialBackOff() {
        this.getRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    public DefaultErrorHandlerDefinition retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.getRedeliveryPolicy().setRetriesExhaustedLogLevel(retriesExhaustedLogLevel.name());
        return this;
    }

    public DefaultErrorHandlerDefinition retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.getRedeliveryPolicy().setRetryAttemptedLogLevel(retryAttemptedLogLevel.name());
        return this;
    }

    public DefaultErrorHandlerDefinition retryAttemptedLogInterval(int retryAttemptedLogInterval) {
        this.getRedeliveryPolicy().setRetryAttemptedLogInterval(String.valueOf(retryAttemptedLogInterval));
        return this;
    }

    public DefaultErrorHandlerDefinition logStackTrace(boolean logStackTrace) {
        this.getRedeliveryPolicy().setLogStackTrace(logStackTrace ? "true" : "false");
        return this;
    }

    public DefaultErrorHandlerDefinition logRetryStackTrace(boolean logRetryStackTrace) {
        this.getRedeliveryPolicy().setLogRetryStackTrace(logRetryStackTrace ? "true" : "false");
        return this;
    }

    public DefaultErrorHandlerDefinition logHandled(boolean logHandled) {
        this.getRedeliveryPolicy().setLogHandled(logHandled ? "true" : "false");
        return this;
    }

    public DefaultErrorHandlerDefinition logNewException(boolean logNewException) {
        this.getRedeliveryPolicy().setLogNewException(logNewException ? "true" : "false");
        return this;
    }

    public DefaultErrorHandlerDefinition logExhausted(boolean logExhausted) {
        this.getRedeliveryPolicy().setLogExhausted(logExhausted ? "true" : "false");
        return this;
    }

    public DefaultErrorHandlerDefinition logRetryAttempted(boolean logRetryAttempted) {
        this.getRedeliveryPolicy().setLogRetryAttempted(logRetryAttempted ? "true" : "false");
        return this;
    }

    public DefaultErrorHandlerDefinition logExhaustedMessageHistory(boolean logExhaustedMessageHistory) {
        this.getRedeliveryPolicy().setLogExhaustedMessageHistory(logExhaustedMessageHistory ? "true" : "false");
        return this;
    }

    public DefaultErrorHandlerDefinition logExhaustedMessageBody(boolean logExhaustedMessageBody) {
        this.getRedeliveryPolicy().setLogExhaustedMessageBody(logExhaustedMessageBody ? "true" : "false");
        return this;
    }

    public DefaultErrorHandlerDefinition exchangeFormatterRef(String exchangeFormatterRef) {
        this.getRedeliveryPolicy().setExchangeFormatterRef(exchangeFormatterRef);
        return this;
    }

    public DefaultErrorHandlerDefinition asyncDelayedRedelivery() {
        this.getRedeliveryPolicy().setAsyncDelayedRedelivery("true");
        return this;
    }

    public DefaultErrorHandlerDefinition allowRedeliveryWhileStopping(boolean allowRedeliveryWhileStopping) {
        this.getRedeliveryPolicy().setAllowRedeliveryWhileStopping(allowRedeliveryWhileStopping ? "true" : "false");
        return this;
    }

    public DefaultErrorHandlerDefinition executorService(ScheduledExecutorService executorService) {
        this.setExecutorServiceBean(executorService);
        return this;
    }

    public DefaultErrorHandlerDefinition executorServiceRef(String ref) {
        this.setExecutorServiceRef(ref);
        return this;
    }

    public DefaultErrorHandlerDefinition logger(CamelLogger logger) {
        this.setLoggerBean(logger);
        return this;
    }

    public DefaultErrorHandlerDefinition loggingLevel(String level) {
        this.setLevel(level);
        return this;
    }

    public DefaultErrorHandlerDefinition loggingLevel(LoggingLevel level) {
        this.setLevel(level.name());
        return this;
    }

    public DefaultErrorHandlerDefinition log(Logger log) {
        if (this.loggerBean == null) {
            this.loggerBean = new CamelLogger(LoggerFactory.getLogger(DefaultErrorHandler.class), LoggingLevel.ERROR);
        }
        this.loggerBean.setLog(log);
        return this;
    }

    public DefaultErrorHandlerDefinition log(String log) {
        return this.log(LoggerFactory.getLogger((String)log));
    }

    public DefaultErrorHandlerDefinition log(Class<?> log) {
        return this.log(LoggerFactory.getLogger(log));
    }

    public DefaultErrorHandlerDefinition onRedelivery(Processor processor) {
        this.setOnRedeliveryProcessor(processor);
        return this;
    }

    public DefaultErrorHandlerDefinition onRedeliveryRef(String onRedeliveryRef) {
        this.setOnRedeliveryRef(onRedeliveryRef);
        return this;
    }

    public DefaultErrorHandlerDefinition retryWhile(Expression retryWhile) {
        this.setRetryWhilePredicate(ExpressionToPredicateAdapter.toPredicate((Expression)retryWhile));
        return this;
    }

    public DefaultErrorHandlerDefinition retryWhileRef(String retryWhileRef) {
        this.setRetryWhileRef(retryWhileRef);
        return this;
    }

    public DefaultErrorHandlerDefinition useOriginalMessage() {
        this.setUseOriginalMessage("true");
        return this;
    }

    public DefaultErrorHandlerDefinition useOriginalBody() {
        this.setUseOriginalBody("true");
        return this;
    }

    public DefaultErrorHandlerDefinition onPrepareFailure(Processor processor) {
        this.setOnPrepareFailureProcessor(processor);
        return this;
    }

    public DefaultErrorHandlerDefinition onPrepareFailureRef(String onPrepareFailureRef) {
        this.setOnPrepareFailureRef(onPrepareFailureRef);
        return this;
    }

    public DefaultErrorHandlerDefinition onExceptionOccurred(Processor processor) {
        this.setOnExceptionOccurredProcessor(processor);
        return this;
    }

    public DefaultErrorHandlerDefinition onExceptionOccurredRef(String onExceptionOccurredRef) {
        this.setOnExceptionOccurredRef(onExceptionOccurredRef);
        return this;
    }

    public DefaultErrorHandlerDefinition redeliveryPolicyRef(String redeliveryPolicyRef) {
        this.setRedeliveryPolicyRef(redeliveryPolicyRef);
        return this;
    }
}

