/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.Predicate;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OnCompletionMode;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="onCompletion")
@XmlType(propOrder={"onWhen", "outputs"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnCompletionDefinition
extends OutputDefinition<OnCompletionDefinition>
implements ExecutorServiceAwareDefinition<OnCompletionDefinition> {
    @XmlTransient
    private ExecutorService executorServiceBean;
    @XmlTransient
    private boolean routeScoped = true;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.model.OnCompletionMode", defaultValue="AfterConsumer", enums="AfterConsumer,BeforeConsumer")
    private String mode;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String onCompleteOnly;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String onFailureOnly;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String parallelProcessing;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ExecutorService")
    private String executorService;
    @XmlAttribute(name="useOriginalMessage")
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String useOriginalMessage;
    @XmlElement(name="onWhen")
    @AsPredicate
    private WhenDefinition onWhen;

    public void setRouteScoped(boolean routeScoped) {
        this.routeScoped = routeScoped;
    }

    public boolean isRouteScoped() {
        return this.routeScoped;
    }

    @Override
    public void setParent(ProcessorDefinition<?> parent) {
        if (this.routeScoped) {
            super.setParent(parent);
        }
    }

    @Override
    public String toString() {
        return "onCompletion[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "onCompletion";
    }

    @Override
    public String getLabel() {
        return "onCompletion";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    public void removeAllOnCompletionDefinition(ProcessorDefinition<?> definition) {
        definition.getOutputs().removeIf(out -> out instanceof OnCompletionDefinition && !((OnCompletionDefinition)out).isRouteScoped());
    }

    @Override
    public ProcessorDefinition<?> end() {
        this.getParent().popBlock();
        return super.end();
    }

    public OnCompletionDefinition modeAfterConsumer() {
        this.setMode(OnCompletionMode.AfterConsumer.name());
        return this;
    }

    public OnCompletionDefinition modeBeforeConsumer() {
        this.setMode(OnCompletionMode.BeforeConsumer.name());
        return this;
    }

    public OnCompletionDefinition onCompleteOnly() {
        boolean isOnFailureOnly = Boolean.toString(true).equals(this.onFailureOnly);
        if (isOnFailureOnly) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        this.setOnCompleteOnly(Boolean.toString(true));
        this.setOnFailureOnly(Boolean.toString(false));
        return this;
    }

    public OnCompletionDefinition onFailureOnly() {
        boolean isOnCompleteOnly = Boolean.toString(true).equals(this.onCompleteOnly);
        if (isOnCompleteOnly) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        this.setOnCompleteOnly(Boolean.toString(false));
        this.setOnFailureOnly(Boolean.toString(true));
        return this;
    }

    public OnCompletionDefinition onWhen(@AsPredicate Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    @Deprecated
    public OnCompletionDefinition useOriginalBody() {
        this.setUseOriginalMessage(Boolean.toString(true));
        return this;
    }

    public OnCompletionDefinition useOriginalMessage() {
        this.setUseOriginalMessage(Boolean.toString(true));
        return this;
    }

    @Override
    public OnCompletionDefinition executorService(ExecutorService executorService) {
        this.executorServiceBean = executorService;
        return this;
    }

    @Override
    public OnCompletionDefinition executorService(String executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public OnCompletionDefinition parallelProcessing() {
        this.setParallelProcessing(Boolean.toString(true));
        return this;
    }

    public OnCompletionDefinition parallelProcessing(boolean parallelProcessing) {
        this.setParallelProcessing(Boolean.toString(parallelProcessing));
        return this;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    @Override
    public ExecutorService getExecutorServiceBean() {
        return this.executorServiceBean;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorService;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getOnCompleteOnly() {
        return this.onCompleteOnly;
    }

    public void setOnCompleteOnly(String onCompleteOnly) {
        this.onCompleteOnly = onCompleteOnly;
    }

    public String getOnFailureOnly() {
        return this.onFailureOnly;
    }

    public void setOnFailureOnly(String onFailureOnly) {
        this.onFailureOnly = onFailureOnly;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    public String getUseOriginalMessage() {
        return this.useOriginalMessage;
    }

    public void setUseOriginalMessage(String useOriginalMessage) {
        this.useOriginalMessage = useOriginalMessage;
    }

    public String getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(String parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.executorService = executorService;
    }
}

