/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.YAMLLibrary;
import org.apache.camel.model.dataformat.YAMLTypeFilterDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.17.0", label="dataformat,transformation,yaml", title="YAML")
@XmlRootElement(name="yaml")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class YAMLDataFormat
extends DataFormatDefinition {
    @XmlTransient
    private ClassLoader classLoader;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute
    @Metadata(defaultValue="SnakeYAML")
    private YAMLLibrary library;
    @XmlAttribute(name="unmarshalType")
    private String unmarshalTypeName;
    @XmlAttribute
    @Metadata(label="advanced")
    private String constructor;
    @XmlAttribute
    @Metadata(label="advanced")
    private String representer;
    @XmlAttribute
    @Metadata(label="advanced")
    private String dumperOptions;
    @XmlAttribute
    @Metadata(label="advanced")
    private String resolver;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String useApplicationContextClassLoader;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String prettyFlow;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowAnyType;
    @XmlElement(name="typeFilter")
    private List<YAMLTypeFilterDefinition> typeFilters;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Integer", defaultValue="50")
    private String maxAliasesForCollections;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String allowRecursiveKeys;

    public YAMLDataFormat() {
        this(YAMLLibrary.SnakeYAML);
    }

    public YAMLDataFormat(YAMLLibrary library) {
        super(library.getDataFormatName());
        this.library = library;
    }

    public YAMLDataFormat(YAMLLibrary library, Class<?> unmarshalType) {
        super(library.getDataFormatName());
        this.library = library;
        this.unmarshalType = unmarshalType;
    }

    private YAMLDataFormat(Builder builder) {
        super(builder.dataFormatName == null ? YAMLLibrary.SnakeYAML.getDataFormatName() : builder.dataFormatName);
        this.classLoader = builder.classLoader;
        this.unmarshalType = builder.unmarshalType;
        this.library = builder.library;
        this.unmarshalTypeName = builder.unmarshalTypeName;
        this.constructor = builder.constructor;
        this.representer = builder.representer;
        this.dumperOptions = builder.dumperOptions;
        this.resolver = builder.resolver;
        this.useApplicationContextClassLoader = builder.useApplicationContextClassLoader;
        this.prettyFlow = builder.prettyFlow;
        this.allowAnyType = builder.allowAnyType;
        this.typeFilters = builder.typeFilters;
        this.maxAliasesForCollections = builder.maxAliasesForCollections;
        this.allowRecursiveKeys = builder.allowRecursiveKeys;
    }

    @Override
    public String getDataFormatName() {
        return this.library != null ? this.library.getDataFormatName() : "snakeYaml";
    }

    public YAMLLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(YAMLLibrary library) {
        this.library = library;
        this.setDataFormatName("yaml-" + library.name().toLowerCase());
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> type) {
        this.unmarshalType = type;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getConstructor() {
        return this.constructor;
    }

    public void setConstructor(String constructor) {
        this.constructor = constructor;
    }

    public String getRepresenter() {
        return this.representer;
    }

    public void setRepresenter(String representer) {
        this.representer = representer;
    }

    public String getDumperOptions() {
        return this.dumperOptions;
    }

    public void setDumperOptions(String dumperOptions) {
        this.dumperOptions = dumperOptions;
    }

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public String getUseApplicationContextClassLoader() {
        return this.useApplicationContextClassLoader;
    }

    public void setUseApplicationContextClassLoader(String useApplicationContextClassLoader) {
        this.useApplicationContextClassLoader = useApplicationContextClassLoader;
    }

    public String getPrettyFlow() {
        return this.prettyFlow;
    }

    public void setPrettyFlow(String prettyFlow) {
        this.prettyFlow = prettyFlow;
    }

    public String getAllowAnyType() {
        return this.allowAnyType;
    }

    public void setAllowAnyType(String allowAnyType) {
        this.allowAnyType = allowAnyType;
    }

    public List<YAMLTypeFilterDefinition> getTypeFilters() {
        return this.typeFilters;
    }

    public void setTypeFilters(List<YAMLTypeFilterDefinition> typeFilters) {
        this.typeFilters = typeFilters;
    }

    public String getMaxAliasesForCollections() {
        return this.maxAliasesForCollections;
    }

    public void setMaxAliasesForCollections(String maxAliasesForCollections) {
        this.maxAliasesForCollections = maxAliasesForCollections;
    }

    public String getAllowRecursiveKeys() {
        return this.allowRecursiveKeys;
    }

    public void setAllowRecursiveKeys(String allowRecursiveKeys) {
        this.allowRecursiveKeys = allowRecursiveKeys;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<YAMLDataFormat> {
        private String dataFormatName;
        private ClassLoader classLoader;
        private Class<?> unmarshalType;
        private YAMLLibrary library = YAMLLibrary.SnakeYAML;
        private String unmarshalTypeName;
        private String constructor;
        private String representer;
        private String dumperOptions;
        private String resolver;
        private String useApplicationContextClassLoader;
        private String prettyFlow;
        private String allowAnyType;
        private List<YAMLTypeFilterDefinition> typeFilters;
        private String maxAliasesForCollections;
        private String allowRecursiveKeys;

        public Builder library(YAMLLibrary library) {
            this.library = library;
            this.dataFormatName = "yaml-" + library.name().toLowerCase();
            return this;
        }

        public Builder unmarshalType(Class<?> unmarshalType) {
            this.unmarshalType = unmarshalType;
            return this;
        }

        public Builder unmarshalTypeName(String unmarshalTypeName) {
            this.unmarshalTypeName = unmarshalTypeName;
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder constructor(String constructor) {
            this.constructor = constructor;
            return this;
        }

        public Builder representer(String representer) {
            this.representer = representer;
            return this;
        }

        public Builder dumperOptions(String dumperOptions) {
            this.dumperOptions = dumperOptions;
            return this;
        }

        public Builder resolver(String resolver) {
            this.resolver = resolver;
            return this;
        }

        public Builder useApplicationContextClassLoader(String useApplicationContextClassLoader) {
            this.useApplicationContextClassLoader = useApplicationContextClassLoader;
            return this;
        }

        public Builder useApplicationContextClassLoader(boolean useApplicationContextClassLoader) {
            this.useApplicationContextClassLoader = Boolean.toString(useApplicationContextClassLoader);
            return this;
        }

        public Builder prettyFlow(String prettyFlow) {
            this.prettyFlow = prettyFlow;
            return this;
        }

        public Builder prettyFlow(boolean prettyFlow) {
            this.prettyFlow = Boolean.toString(prettyFlow);
            return this;
        }

        public Builder allowAnyType(String allowAnyType) {
            this.allowAnyType = allowAnyType;
            return this;
        }

        public Builder allowAnyType(boolean allowAnyType) {
            this.allowAnyType = Boolean.toString(allowAnyType);
            return this;
        }

        public Builder typeFilters(List<YAMLTypeFilterDefinition> typeFilters) {
            this.typeFilters = typeFilters;
            return this;
        }

        public Builder maxAliasesForCollections(String maxAliasesForCollections) {
            this.maxAliasesForCollections = maxAliasesForCollections;
            return this;
        }

        public Builder maxAliasesForCollections(int maxAliasesForCollections) {
            this.maxAliasesForCollections = Integer.toString(maxAliasesForCollections);
            return this;
        }

        public Builder allowRecursiveKeys(String allowRecursiveKeys) {
            this.allowRecursiveKeys = allowRecursiveKeys;
            return this;
        }

        public Builder allowRecursiveKeys(boolean allowRecursiveKeys) {
            this.allowRecursiveKeys = Boolean.toString(allowRecursiveKeys);
            return this;
        }

        @Override
        public YAMLDataFormat end() {
            return new YAMLDataFormat(this);
        }
    }
}

