/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestHostNameResolver;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.CamelContextHelper;

@Metadata(label="rest")
@XmlRootElement(name="restConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestConfigurationDefinition {
    @XmlAttribute
    @Metadata(enums="platform-http,servlet,jetty,undertow,netty-http,coap")
    private String component;
    @XmlAttribute
    @Metadata(label="consumer,advanced", enums="openapi,swagger")
    private String apiComponent;
    @XmlAttribute
    @Metadata(label="producer,advanced", enums="vertx-http,http,undertow,netty-http")
    private String producerComponent;
    @XmlAttribute
    private String scheme;
    @XmlAttribute
    private String host;
    @XmlAttribute
    private String port;
    @XmlAttribute
    @Metadata(label="consumer,advanced")
    private String apiHost;
    @XmlAttribute
    @Metadata(label="consumer,advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String useXForwardHeaders;
    @XmlAttribute
    @Metadata(label="producer,advanced")
    private String producerApiDoc;
    @XmlAttribute
    @Metadata(label="consumer")
    private String contextPath;
    @XmlAttribute
    @Metadata(label="consumer")
    private String apiContextPath;
    @XmlAttribute
    @Metadata(label="consumer,advanced")
    private String apiContextRouteId;
    @XmlAttribute
    @Metadata(label="consumer,advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String apiVendorExtension;
    @XmlAttribute
    @Metadata(label="consumer,advanced", defaultValue="allLocalIp")
    private RestHostNameResolver hostNameResolver;
    @XmlAttribute
    @Metadata(defaultValue="off", enums="off,auto,json,xml,json_xml")
    private RestBindingMode bindingMode;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String skipBindingOnErrorCode;
    @XmlAttribute
    @Metadata(label="consumer,advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String clientRequestValidation;
    @XmlAttribute
    @Metadata(label="consumer,advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String enableCORS;
    @XmlAttribute
    @Metadata(label="consumer", javaType="java.lang.Boolean", defaultValue="false")
    private String inlineRoutes;
    @XmlAttribute
    @Metadata(label="advanced")
    private String jsonDataFormat;
    @XmlAttribute
    @Metadata(label="advanced")
    private String xmlDataFormat;
    @XmlElement(name="componentProperty")
    @Metadata(label="advanced")
    private List<RestPropertyDefinition> componentProperties = new ArrayList<RestPropertyDefinition>();
    @XmlElement(name="endpointProperty")
    @Metadata(label="advanced")
    private List<RestPropertyDefinition> endpointProperties = new ArrayList<RestPropertyDefinition>();
    @XmlElement(name="consumerProperty")
    @Metadata(label="consumer,advanced")
    private List<RestPropertyDefinition> consumerProperties = new ArrayList<RestPropertyDefinition>();
    @XmlElement(name="dataFormatProperty")
    @Metadata(label="advanced")
    private List<RestPropertyDefinition> dataFormatProperties = new ArrayList<RestPropertyDefinition>();
    @XmlElement(name="apiProperty")
    @Metadata(label="consumer,advanced")
    private List<RestPropertyDefinition> apiProperties = new ArrayList<RestPropertyDefinition>();
    @XmlElement(name="corsHeaders")
    @Metadata(label="consumer,advanced")
    private List<RestPropertyDefinition> corsHeaders = new ArrayList<RestPropertyDefinition>();

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getApiComponent() {
        return this.apiComponent;
    }

    public void setApiComponent(String apiComponent) {
        this.apiComponent = apiComponent;
    }

    public String getProducerComponent() {
        return this.producerComponent;
    }

    public void setProducerComponent(String producerComponent) {
        this.producerComponent = producerComponent;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProducerApiDoc() {
        return this.producerApiDoc;
    }

    public void setProducerApiDoc(String producerApiDoc) {
        this.producerApiDoc = producerApiDoc;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getApiContextPath() {
        return this.apiContextPath;
    }

    public void setApiContextPath(String contextPath) {
        this.apiContextPath = contextPath;
    }

    public String getApiContextRouteId() {
        return this.apiContextRouteId;
    }

    public void setApiContextRouteId(String apiContextRouteId) {
        this.apiContextRouteId = apiContextRouteId;
    }

    public String getApiVendorExtension() {
        return this.apiVendorExtension;
    }

    public void setApiVendorExtension(String apiVendorExtension) {
        this.apiVendorExtension = apiVendorExtension;
    }

    public RestHostNameResolver getHostNameResolver() {
        return this.hostNameResolver;
    }

    public void setHostNameResolver(RestHostNameResolver hostNameResolver) {
        this.hostNameResolver = hostNameResolver;
    }

    public RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public String getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(String skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public String getClientRequestValidation() {
        return this.clientRequestValidation;
    }

    public void setClientRequestValidation(String clientRequestValidation) {
        this.clientRequestValidation = clientRequestValidation;
    }

    public String getEnableCORS() {
        return this.enableCORS;
    }

    public void setEnableCORS(String enableCORS) {
        this.enableCORS = enableCORS;
    }

    public String getInlineRoutes() {
        return this.inlineRoutes;
    }

    public void setInlineRoutes(String inlineRoutes) {
        this.inlineRoutes = inlineRoutes;
    }

    public String getJsonDataFormat() {
        return this.jsonDataFormat;
    }

    public void setJsonDataFormat(String jsonDataFormat) {
        this.jsonDataFormat = jsonDataFormat;
    }

    public String getXmlDataFormat() {
        return this.xmlDataFormat;
    }

    public void setXmlDataFormat(String xmlDataFormat) {
        this.xmlDataFormat = xmlDataFormat;
    }

    public List<RestPropertyDefinition> getComponentProperties() {
        return this.componentProperties;
    }

    public void setComponentProperties(List<RestPropertyDefinition> componentProperties) {
        this.componentProperties = componentProperties;
    }

    public List<RestPropertyDefinition> getEndpointProperties() {
        return this.endpointProperties;
    }

    public void setEndpointProperties(List<RestPropertyDefinition> endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    public List<RestPropertyDefinition> getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(List<RestPropertyDefinition> consumerProperties) {
        this.consumerProperties = consumerProperties;
    }

    public List<RestPropertyDefinition> getDataFormatProperties() {
        return this.dataFormatProperties;
    }

    public void setDataFormatProperties(List<RestPropertyDefinition> dataFormatProperties) {
        this.dataFormatProperties = dataFormatProperties;
    }

    public List<RestPropertyDefinition> getApiProperties() {
        return this.apiProperties;
    }

    public void setApiProperties(List<RestPropertyDefinition> apiProperties) {
        this.apiProperties = apiProperties;
    }

    public List<RestPropertyDefinition> getCorsHeaders() {
        return this.corsHeaders;
    }

    public void setCorsHeaders(List<RestPropertyDefinition> corsHeaders) {
        this.corsHeaders = corsHeaders;
    }

    public String getUseXForwardHeaders() {
        return this.useXForwardHeaders;
    }

    public void setUseXForwardHeaders(String useXForwardHeaders) {
        this.useXForwardHeaders = useXForwardHeaders;
    }

    public RestConfigurationDefinition component(String componentId) {
        this.setComponent(componentId);
        return this;
    }

    public RestConfigurationDefinition apiComponent(String componentId) {
        this.setApiComponent(componentId);
        return this;
    }

    public RestConfigurationDefinition producerComponent(String componentId) {
        this.setProducerComponent(componentId);
        return this;
    }

    public RestConfigurationDefinition scheme(String scheme) {
        this.setScheme(scheme);
        return this;
    }

    public RestConfigurationDefinition host(String host) {
        this.setHost(host);
        return this;
    }

    public RestConfigurationDefinition apiHost(String host) {
        this.setApiHost(host);
        return this;
    }

    public RestConfigurationDefinition port(int port) {
        this.setPort(Integer.toString(port));
        return this;
    }

    public RestConfigurationDefinition port(String port) {
        this.setPort(port);
        return this;
    }

    public RestConfigurationDefinition producerApiDoc(String apiDoc) {
        this.setProducerApiDoc(apiDoc);
        return this;
    }

    public RestConfigurationDefinition apiContextPath(String contextPath) {
        this.setApiContextPath(contextPath);
        return this;
    }

    public RestConfigurationDefinition apiContextRouteId(String apiContextRouteId) {
        this.setApiContextRouteId(apiContextRouteId);
        return this;
    }

    public RestConfigurationDefinition apiVendorExtension(boolean vendorExtension) {
        this.setApiVendorExtension(vendorExtension ? "true" : "false");
        return this;
    }

    public RestConfigurationDefinition apiVendorExtension(String vendorExtension) {
        this.setApiVendorExtension(vendorExtension);
        return this;
    }

    public RestConfigurationDefinition contextPath(String contextPath) {
        this.setContextPath(contextPath);
        return this;
    }

    public RestConfigurationDefinition hostNameResolver(RestHostNameResolver hostNameResolver) {
        this.setHostNameResolver(hostNameResolver);
        return this;
    }

    public RestConfigurationDefinition bindingMode(RestBindingMode bindingMode) {
        this.setBindingMode(bindingMode);
        return this;
    }

    public RestConfigurationDefinition bindingMode(String bindingMode) {
        this.setBindingMode(RestBindingMode.valueOf(bindingMode.toLowerCase()));
        return this;
    }

    public RestConfigurationDefinition skipBindingOnErrorCode(boolean skipBindingOnErrorCode) {
        this.setSkipBindingOnErrorCode(skipBindingOnErrorCode ? "true" : "false");
        return this;
    }

    public RestConfigurationDefinition skipBindingOnErrorCode(String skipBindingOnErrorCode) {
        this.setSkipBindingOnErrorCode(skipBindingOnErrorCode);
        return this;
    }

    public RestConfigurationDefinition clientRequestValidation(boolean clientRequestValidation) {
        this.setClientRequestValidation(clientRequestValidation ? "true" : "false");
        return this;
    }

    public RestConfigurationDefinition clientRequestValidation(String clientRequestValidation) {
        this.setClientRequestValidation(clientRequestValidation);
        return this;
    }

    public RestConfigurationDefinition enableCORS(boolean enableCORS) {
        this.setEnableCORS(enableCORS ? "true" : "false");
        return this;
    }

    public RestConfigurationDefinition enableCORS(String enableCORS) {
        this.setEnableCORS(enableCORS);
        return this;
    }

    public RestConfigurationDefinition inlineRoutes(String inlineRoutes) {
        this.setInlineRoutes(inlineRoutes);
        return this;
    }

    public RestConfigurationDefinition inlineRoutes(boolean inlineRoutes) {
        this.setInlineRoutes(inlineRoutes ? "true" : "false");
        return this;
    }

    public RestConfigurationDefinition jsonDataFormat(String name) {
        this.setJsonDataFormat(name);
        return this;
    }

    public RestConfigurationDefinition xmlDataFormat(String name) {
        this.setXmlDataFormat(name);
        return this;
    }

    public RestConfigurationDefinition componentProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getComponentProperties().add(prop);
        return this;
    }

    public RestConfigurationDefinition endpointProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getEndpointProperties().add(prop);
        return this;
    }

    public RestConfigurationDefinition consumerProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getConsumerProperties().add(prop);
        return this;
    }

    public RestConfigurationDefinition dataFormatProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getDataFormatProperties().add(prop);
        return this;
    }

    public RestConfigurationDefinition apiProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getApiProperties().add(prop);
        return this;
    }

    public RestConfigurationDefinition corsHeaderProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getCorsHeaders().add(prop);
        return this;
    }

    public RestConfigurationDefinition corsAllowCredentials(boolean corsAllowCredentials) {
        return this.corsHeaderProperty("Access-Control-Allow-Credentials", String.valueOf(corsAllowCredentials));
    }

    public RestConfigurationDefinition useXForwardHeaders(boolean useXForwardHeaders) {
        this.setUseXForwardHeaders(useXForwardHeaders ? "true" : "false");
        return this;
    }

    public RestConfigurationDefinition useXForwardHeaders(String useXForwardHeaders) {
        this.setUseXForwardHeaders(useXForwardHeaders);
        return this;
    }

    public RestConfiguration asRestConfiguration(CamelContext context, RestConfiguration target) throws Exception {
        String value;
        String key;
        HashMap<String, String> props;
        if (this.component != null) {
            target.setComponent(CamelContextHelper.parseText((CamelContext)context, (String)this.component));
        }
        if (this.apiComponent != null) {
            target.setApiComponent(CamelContextHelper.parseText((CamelContext)context, (String)this.apiComponent));
        }
        if (this.producerComponent != null) {
            target.setProducerComponent(CamelContextHelper.parseText((CamelContext)context, (String)this.producerComponent));
        }
        if (this.scheme != null) {
            target.setScheme(CamelContextHelper.parseText((CamelContext)context, (String)this.scheme));
        }
        if (this.host != null) {
            target.setHost(CamelContextHelper.parseText((CamelContext)context, (String)this.host));
        }
        if (this.useXForwardHeaders != null) {
            target.setUseXForwardHeaders(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.useXForwardHeaders).booleanValue());
        }
        if (this.apiHost != null) {
            target.setApiHost(CamelContextHelper.parseText((CamelContext)context, (String)this.apiHost));
        }
        if (this.port != null) {
            target.setPort(CamelContextHelper.parseInteger((CamelContext)context, (String)this.port).intValue());
        }
        if (this.producerApiDoc != null) {
            target.setProducerApiDoc(CamelContextHelper.parseText((CamelContext)context, (String)this.producerApiDoc));
        }
        if (this.apiContextPath != null) {
            target.setApiContextPath(CamelContextHelper.parseText((CamelContext)context, (String)this.apiContextPath));
        }
        if (this.apiContextRouteId != null) {
            target.setApiContextRouteId(CamelContextHelper.parseText((CamelContext)context, (String)this.apiContextRouteId));
        }
        if (this.apiVendorExtension != null) {
            target.setApiVendorExtension(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.apiVendorExtension).booleanValue());
        }
        if (this.contextPath != null) {
            target.setContextPath(CamelContextHelper.parseText((CamelContext)context, (String)this.contextPath));
        }
        if (this.hostNameResolver != null) {
            target.setHostNameResolver(this.hostNameResolver.name());
        }
        if (this.bindingMode != null) {
            target.setBindingMode(this.bindingMode.name());
        }
        if (this.skipBindingOnErrorCode != null) {
            target.setSkipBindingOnErrorCode(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.skipBindingOnErrorCode).booleanValue());
        }
        if (this.clientRequestValidation != null) {
            target.setClientRequestValidation(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.clientRequestValidation).booleanValue());
        }
        if (this.enableCORS != null) {
            target.setEnableCORS(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.enableCORS).booleanValue());
        }
        if (this.inlineRoutes != null) {
            target.setInlineRoutes(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.inlineRoutes).booleanValue());
        }
        if (this.jsonDataFormat != null) {
            target.setJsonDataFormat(this.jsonDataFormat);
        }
        if (this.xmlDataFormat != null) {
            target.setXmlDataFormat(this.xmlDataFormat);
        }
        if (!this.componentProperties.isEmpty()) {
            props = new HashMap<String, String>();
            for (RestPropertyDefinition prop : this.componentProperties) {
                key = prop.getKey();
                value = CamelContextHelper.parseText((CamelContext)context, (String)prop.getValue());
                props.put(key, value);
            }
            target.setComponentProperties(props);
        }
        if (!this.endpointProperties.isEmpty()) {
            props = new HashMap();
            for (RestPropertyDefinition prop : this.endpointProperties) {
                key = prop.getKey();
                value = CamelContextHelper.parseText((CamelContext)context, (String)prop.getValue());
                props.put(key, value);
            }
            target.setEndpointProperties(props);
        }
        if (!this.consumerProperties.isEmpty()) {
            props = new HashMap();
            for (RestPropertyDefinition prop : this.consumerProperties) {
                key = prop.getKey();
                value = CamelContextHelper.parseText((CamelContext)context, (String)prop.getValue());
                props.put(key, value);
            }
            target.setConsumerProperties(props);
        }
        if (!this.dataFormatProperties.isEmpty()) {
            props = new HashMap();
            for (RestPropertyDefinition prop : this.dataFormatProperties) {
                key = prop.getKey();
                value = CamelContextHelper.parseText((CamelContext)context, (String)prop.getValue());
                props.put(key, value);
            }
            target.setDataFormatProperties(props);
        }
        if (!this.apiProperties.isEmpty()) {
            props = new HashMap();
            for (RestPropertyDefinition prop : this.apiProperties) {
                key = prop.getKey();
                value = CamelContextHelper.parseText((CamelContext)context, (String)prop.getValue());
                props.put(key, value);
            }
            target.setApiProperties(props);
        }
        if (!this.corsHeaders.isEmpty()) {
            props = new HashMap();
            for (RestPropertyDefinition prop : this.corsHeaders) {
                key = prop.getKey();
                value = CamelContextHelper.parseText((CamelContext)context, (String)prop.getValue());
                props.put(key, value);
            }
            target.setCorsHeaders(props);
        }
        return target;
    }
}

