/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.model.CopyableDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.dataformat.ASN1DataFormat;
import org.apache.camel.model.dataformat.AvroDataFormat;
import org.apache.camel.model.dataformat.BarcodeDataFormat;
import org.apache.camel.model.dataformat.Base64DataFormat;
import org.apache.camel.model.dataformat.BeanioDataFormat;
import org.apache.camel.model.dataformat.BindyDataFormat;
import org.apache.camel.model.dataformat.CBORDataFormat;
import org.apache.camel.model.dataformat.CryptoDataFormat;
import org.apache.camel.model.dataformat.CsvDataFormat;
import org.apache.camel.model.dataformat.CustomDataFormat;
import org.apache.camel.model.dataformat.DfdlDataFormat;
import org.apache.camel.model.dataformat.FhirJsonDataFormat;
import org.apache.camel.model.dataformat.FhirXmlDataFormat;
import org.apache.camel.model.dataformat.FlatpackDataFormat;
import org.apache.camel.model.dataformat.ForyDataFormat;
import org.apache.camel.model.dataformat.GrokDataFormat;
import org.apache.camel.model.dataformat.GroovyXmlDataFormat;
import org.apache.camel.model.dataformat.GzipDeflaterDataFormat;
import org.apache.camel.model.dataformat.HL7DataFormat;
import org.apache.camel.model.dataformat.IcalDataFormat;
import org.apache.camel.model.dataformat.Iso8583DataFormat;
import org.apache.camel.model.dataformat.JacksonXMLDataFormat;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.JsonApiDataFormat;
import org.apache.camel.model.dataformat.JsonDataFormat;
import org.apache.camel.model.dataformat.LZFDataFormat;
import org.apache.camel.model.dataformat.MimeMultipartDataFormat;
import org.apache.camel.model.dataformat.PGPDataFormat;
import org.apache.camel.model.dataformat.ParquetAvroDataFormat;
import org.apache.camel.model.dataformat.ProtobufDataFormat;
import org.apache.camel.model.dataformat.RssDataFormat;
import org.apache.camel.model.dataformat.SmooksDataFormat;
import org.apache.camel.model.dataformat.SoapDataFormat;
import org.apache.camel.model.dataformat.SwiftMtDataFormat;
import org.apache.camel.model.dataformat.SwiftMxDataFormat;
import org.apache.camel.model.dataformat.SyslogDataFormat;
import org.apache.camel.model.dataformat.TarFileDataFormat;
import org.apache.camel.model.dataformat.ThriftDataFormat;
import org.apache.camel.model.dataformat.UniVocityCsvDataFormat;
import org.apache.camel.model.dataformat.UniVocityFixedDataFormat;
import org.apache.camel.model.dataformat.UniVocityTsvDataFormat;
import org.apache.camel.model.dataformat.XMLSecurityDataFormat;
import org.apache.camel.model.dataformat.YAMLDataFormat;
import org.apache.camel.model.dataformat.ZipDeflaterDataFormat;
import org.apache.camel.model.dataformat.ZipFileDataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;

@Metadata(label="dataformat,transformation", title="Data formats")
@XmlRootElement(name="dataFormats")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataFormatsDefinition
implements CopyableDefinition<DataFormatsDefinition>,
ResourceAware {
    @XmlElements(value={@XmlElement(name="asn1", type=ASN1DataFormat.class), @XmlElement(name="avro", type=AvroDataFormat.class), @XmlElement(name="barcode", type=BarcodeDataFormat.class), @XmlElement(name="base64", type=Base64DataFormat.class), @XmlElement(name="beanio", type=BeanioDataFormat.class), @XmlElement(name="bindy", type=BindyDataFormat.class), @XmlElement(name="cbor", type=CBORDataFormat.class), @XmlElement(name="crypto", type=CryptoDataFormat.class), @XmlElement(name="csv", type=CsvDataFormat.class), @XmlElement(name="custom", type=CustomDataFormat.class), @XmlElement(name="dfdl", type=DfdlDataFormat.class), @XmlElement(name="fhirJson", type=FhirJsonDataFormat.class), @XmlElement(name="fhirXml", type=FhirXmlDataFormat.class), @XmlElement(name="flatpack", type=FlatpackDataFormat.class), @XmlElement(name="fory", type=ForyDataFormat.class), @XmlElement(name="grok", type=GrokDataFormat.class), @XmlElement(name="groovyXml", type=GroovyXmlDataFormat.class), @XmlElement(name="gzipDeflater", type=GzipDeflaterDataFormat.class), @XmlElement(name="hl7", type=HL7DataFormat.class), @XmlElement(name="ical", type=IcalDataFormat.class), @XmlElement(name="iso8583", type=Iso8583DataFormat.class), @XmlElement(name="jacksonXml", type=JacksonXMLDataFormat.class), @XmlElement(name="jaxb", type=JaxbDataFormat.class), @XmlElement(name="json", type=JsonDataFormat.class), @XmlElement(name="jsonApi", type=JsonApiDataFormat.class), @XmlElement(name="lzf", type=LZFDataFormat.class), @XmlElement(name="mimeMultipart", type=MimeMultipartDataFormat.class), @XmlElement(name="parquetAvro", type=ParquetAvroDataFormat.class), @XmlElement(name="pgp", type=PGPDataFormat.class), @XmlElement(name="protobuf", type=ProtobufDataFormat.class), @XmlElement(name="rss", type=RssDataFormat.class), @XmlElement(name="smooks", type=SmooksDataFormat.class), @XmlElement(name="soap", type=SoapDataFormat.class), @XmlElement(name="swiftMt", type=SwiftMtDataFormat.class), @XmlElement(name="swiftMx", type=SwiftMxDataFormat.class), @XmlElement(name="syslog", type=SyslogDataFormat.class), @XmlElement(name="tarFile", type=TarFileDataFormat.class), @XmlElement(name="thrift", type=ThriftDataFormat.class), @XmlElement(name="univocityCsv", type=UniVocityCsvDataFormat.class), @XmlElement(name="univocityFixed", type=UniVocityFixedDataFormat.class), @XmlElement(name="univocityTsv", type=UniVocityTsvDataFormat.class), @XmlElement(name="xmlSecurity", type=XMLSecurityDataFormat.class), @XmlElement(name="yaml", type=YAMLDataFormat.class), @XmlElement(name="zipDeflater", type=ZipDeflaterDataFormat.class), @XmlElement(name="zipFile", type=ZipFileDataFormat.class)})
    private List<DataFormatDefinition> dataFormats;
    @XmlTransient
    private Resource resource;

    public DataFormatsDefinition() {
    }

    protected DataFormatsDefinition(DataFormatsDefinition source) {
        this.dataFormats = ProcessorDefinitionHelper.deepCopyDefinitions(source.dataFormats);
    }

    @Override
    public DataFormatsDefinition copyDefinition() {
        return new DataFormatsDefinition(this);
    }

    public void setDataFormats(List<DataFormatDefinition> dataFormats) {
        this.dataFormats = dataFormats;
    }

    public List<DataFormatDefinition> getDataFormats() {
        return this.dataFormats;
    }

    public Map<String, DataFormatDefinition> asMap() {
        HashMap<String, DataFormatDefinition> dataFormatsAsMap = new HashMap<String, DataFormatDefinition>();
        for (DataFormatDefinition dataFormatType : this.getDataFormats()) {
            dataFormatsAsMap.put(dataFormatType.getId(), dataFormatType);
        }
        return dataFormatsAsMap;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

