/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.0.0", label="dataformat,transformation,health", title="HL7")
@XmlRootElement(name="hl7")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class HL7DataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(label="advanced", javaType="ca.uhn.hl7v2.parser.Parser")
    private String parser;
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    private String validate;

    public HL7DataFormat() {
        super("hl7");
    }

    protected HL7DataFormat(HL7DataFormat source) {
        super(source);
        this.parser = source.parser;
        this.validate = source.validate;
    }

    private HL7DataFormat(Builder builder) {
        this();
        this.parser = builder.parser;
        this.validate = builder.validate;
    }

    @Override
    public HL7DataFormat copyDefinition() {
        return new HL7DataFormat(this);
    }

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    public String getParser() {
        return this.parser;
    }

    public void setParser(String parser) {
        this.parser = parser;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<HL7DataFormat> {
        private String parser;
        private String validate;

        public Builder validate(String validate) {
            this.validate = validate;
            return this;
        }

        public Builder validate(boolean validate) {
            this.validate = Boolean.toString(validate);
            return this;
        }

        public Builder parser(String parser) {
            this.parser = parser;
            return this;
        }

        @Override
        public HL7DataFormat end() {
            return new HL7DataFormat(this);
        }
    }
}

