/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="4.16.0", label="dataformat,transformation,security", title="PQC (Post-Quantum Cryptography)")
@XmlRootElement(name="pqc")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PQCDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(defaultValue="MLKEM", enums="MLKEM,BIKE,HQC,CMCE,SABER,FRODO,NTRU,NTRULPRime,SNTRUPrime,KYBER")
    private String keyEncapsulationAlgorithm;
    @XmlAttribute
    @Metadata(defaultValue="AES", enums="AES,ARIA,RC2,RC5,CAMELLIA,CAST5,CAST6,CHACHA7539,DSTU7624,GOST28147,GOST3412_2015,GRAIN128,HC128,HC256,SALSA20,SEED,SM4,DESEDE")
    private String symmetricKeyAlgorithm;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer", defaultValue="128")
    private String symmetricKeyLength;
    @XmlAttribute
    @Metadata(javaType="java.security.KeyPair")
    private String keyPair;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Integer", defaultValue="4096")
    private String bufferSize;
    @XmlAttribute
    @Metadata(label="advanced")
    private String provider;
    @XmlAttribute
    @Metadata(label="advanced", javaType="javax.crypto.KeyGenerator")
    private String keyGenerator;

    public PQCDataFormat() {
        super("pqc");
    }

    protected PQCDataFormat(PQCDataFormat source) {
        super(source);
        this.keyEncapsulationAlgorithm = source.keyEncapsulationAlgorithm;
        this.symmetricKeyAlgorithm = source.symmetricKeyAlgorithm;
        this.symmetricKeyLength = source.symmetricKeyLength;
        this.keyPair = source.keyPair;
        this.bufferSize = source.bufferSize;
        this.provider = source.provider;
        this.keyGenerator = source.keyGenerator;
    }

    private PQCDataFormat(Builder builder) {
        this();
        this.keyEncapsulationAlgorithm = builder.keyEncapsulationAlgorithm;
        this.symmetricKeyAlgorithm = builder.symmetricKeyAlgorithm;
        this.symmetricKeyLength = builder.symmetricKeyLength;
        this.keyPair = builder.keyPair;
        this.bufferSize = builder.bufferSize;
        this.provider = builder.provider;
        this.keyGenerator = builder.keyGenerator;
    }

    @Override
    public PQCDataFormat copyDefinition() {
        return new PQCDataFormat(this);
    }

    public String getKeyEncapsulationAlgorithm() {
        return this.keyEncapsulationAlgorithm;
    }

    public void setKeyEncapsulationAlgorithm(String keyEncapsulationAlgorithm) {
        this.keyEncapsulationAlgorithm = keyEncapsulationAlgorithm;
    }

    public String getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public void setSymmetricKeyAlgorithm(String symmetricKeyAlgorithm) {
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
    }

    public String getSymmetricKeyLength() {
        return this.symmetricKeyLength;
    }

    public void setSymmetricKeyLength(String symmetricKeyLength) {
        this.symmetricKeyLength = symmetricKeyLength;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(String keyPair) {
        this.keyPair = keyPair;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(String keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<PQCDataFormat> {
        private String keyEncapsulationAlgorithm = "MLKEM";
        private String symmetricKeyAlgorithm = "AES";
        private String symmetricKeyLength;
        private String keyPair;
        private String bufferSize;
        private String provider;
        private String keyGenerator;

        public Builder keyEncapsulationAlgorithm(String keyEncapsulationAlgorithm) {
            this.keyEncapsulationAlgorithm = keyEncapsulationAlgorithm;
            return this;
        }

        public Builder symmetricKeyAlgorithm(String symmetricKeyAlgorithm) {
            this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
            return this;
        }

        public Builder symmetricKeyLength(String symmetricKeyLength) {
            this.symmetricKeyLength = symmetricKeyLength;
            return this;
        }

        public Builder symmetricKeyLength(int symmetricKeyLength) {
            this.symmetricKeyLength = Integer.toString(symmetricKeyLength);
            return this;
        }

        public Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public Builder bufferSize(String bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = Integer.toString(bufferSize);
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder keyGenerator(String keyGenerator) {
            this.keyGenerator = keyGenerator;
            return this;
        }

        @Override
        public PQCDataFormat end() {
            return new PQCDataFormat(this);
        }
    }
}

