/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.3.0", label="dataformat,transformation,xml", title="SOAP")
@XmlRootElement(name="soap")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SoapDataFormat
extends DataFormatDefinition {
    @XmlTransient
    private Object elementNameStrategyObject;
    @XmlAttribute(required=true)
    private String contextPath;
    @XmlAttribute
    private String encoding;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.dataformat.soap.name.ElementNameStrategy")
    private String elementNameStrategy;
    @XmlAttribute
    @Metadata(defaultValue="1.1", enums="1.1,1.2")
    private String version;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.Map")
    private String namespacePrefix;
    @XmlAttribute
    private String schema;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String ignoreUnmarshalledHeaders;

    public SoapDataFormat() {
        super("soap");
    }

    protected SoapDataFormat(SoapDataFormat source) {
        super(source);
        this.contextPath = source.contextPath;
        this.encoding = source.encoding;
        this.elementNameStrategy = source.elementNameStrategy;
        this.elementNameStrategyObject = source.elementNameStrategyObject;
        this.version = source.version;
        this.namespacePrefix = source.namespacePrefix;
        this.schema = source.schema;
        this.ignoreUnmarshalledHeaders = source.ignoreUnmarshalledHeaders;
    }

    public SoapDataFormat(String contextPath) {
        this();
        this.setContextPath(contextPath);
    }

    public SoapDataFormat(String contextPath, String elementNameStrategyRef) {
        this();
        this.setContextPath(contextPath);
        this.setElementNameStrategy(elementNameStrategyRef);
    }

    public SoapDataFormat(String contextPath, Object elementNameStrategyObject) {
        this();
        this.setContextPath(contextPath);
        this.setElementNameStrategyObject(elementNameStrategyObject);
    }

    private SoapDataFormat(Builder builder) {
        this();
        this.contextPath = builder.contextPath;
        this.encoding = builder.encoding;
        this.elementNameStrategy = builder.elementNameStrategy;
        this.elementNameStrategyObject = builder.elementNameStrategyObject;
        this.version = builder.version;
        this.namespacePrefix = builder.namespacePrefix;
        this.schema = builder.schema;
        this.ignoreUnmarshalledHeaders = builder.ignoreUnmarshalledHeaders;
    }

    @Override
    public SoapDataFormat copyDefinition() {
        return new SoapDataFormat(this);
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setElementNameStrategy(String elementNameStrategy) {
        this.elementNameStrategy = elementNameStrategy;
    }

    public String getElementNameStrategy() {
        return this.elementNameStrategy;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setElementNameStrategyObject(Object elementNameStrategyObject) {
        this.elementNameStrategyObject = elementNameStrategyObject;
    }

    public Object getElementNameStrategyObject() {
        return this.elementNameStrategyObject;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getIgnoreUnmarshalledHeaders() {
        return this.ignoreUnmarshalledHeaders;
    }

    public void setIgnoreUnmarshalledHeaders(String ignoreUnmarshalledHeaders) {
        this.ignoreUnmarshalledHeaders = ignoreUnmarshalledHeaders;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<SoapDataFormat> {
        private String contextPath;
        private String encoding;
        private String elementNameStrategy;
        private Object elementNameStrategyObject;
        private String version;
        private String namespacePrefix;
        private String schema;
        private String ignoreUnmarshalledHeaders;

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder elementNameStrategy(String elementNameStrategy) {
            this.elementNameStrategy = elementNameStrategy;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder elementNameStrategyObject(Object elementNameStrategyObject) {
            this.elementNameStrategyObject = elementNameStrategyObject;
            return this;
        }

        public Builder namespacePrefix(String namespacePrefix) {
            this.namespacePrefix = namespacePrefix;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder ignoreUnmarshalledHeaders(boolean ignoreUnmarshalledHeaders) {
            return this.ignoreUnmarshalledHeaders(ignoreUnmarshalledHeaders);
        }

        public Builder ignoreUnmarshalledHeaders(String ignoreUnmarshalledHeaders) {
            this.ignoreUnmarshalledHeaders = ignoreUnmarshalledHeaders;
            return this;
        }

        @Override
        public SoapDataFormat end() {
            return new SoapDataFormat(this);
        }
    }
}

