/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.idempotent.IdempotentConsumer;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.util.ObjectHelper;

public class IdempotentConsumerReifier
extends ExpressionReifier<IdempotentConsumerDefinition> {
    public IdempotentConsumerReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (IdempotentConsumerDefinition)IdempotentConsumerDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor childProcessor = this.createChildProcessor(true);
        IdempotentRepository idempotentRepository = this.resolveMessageIdRepository();
        ObjectHelper.notNull((Object)idempotentRepository, (String)"idempotentRepository", (Object)this.definition);
        Expression expression = this.createExpression(((IdempotentConsumerDefinition)this.definition).getExpression());
        boolean eager = this.parseBoolean(((IdempotentConsumerDefinition)this.definition).getEager(), true);
        boolean duplicate = this.parseBoolean(((IdempotentConsumerDefinition)this.definition).getSkipDuplicate(), true);
        boolean remove = this.parseBoolean(((IdempotentConsumerDefinition)this.definition).getRemoveOnFailure(), true);
        boolean completionEager = this.parseBoolean(((IdempotentConsumerDefinition)this.definition).getCompletionEager(), false);
        return new IdempotentConsumer(expression, idempotentRepository, eager, completionEager, duplicate, remove, childProcessor);
    }

    protected <T> IdempotentRepository resolveMessageIdRepository() {
        String ref = this.parseString(((IdempotentConsumerDefinition)this.definition).getMessageIdRepositoryRef());
        if (ref != null) {
            ((IdempotentConsumerDefinition)this.definition).setMessageIdRepository(this.mandatoryLookup(ref, IdempotentRepository.class));
        }
        return ((IdempotentConsumerDefinition)this.definition).getMessageIdRepository();
    }
}

