/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.reifier.ProcessorReifier;

public class CatchReifier
extends ProcessorReifier<CatchDefinition> {
    public CatchReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (CatchDefinition)CatchDefinition.class.cast(definition));
    }

    public CatchProcessor createProcessor() throws Exception {
        if (((CatchDefinition)this.definition).getExceptionClasses() == null) {
            ((CatchDefinition)this.definition).setExceptionClasses(this.createExceptionClasses());
        }
        if (((CatchDefinition)this.definition).getExceptionClasses().isEmpty()) {
            throw new IllegalArgumentException("At least one Exception must be configured to catch");
        }
        if (!(((CatchDefinition)this.definition).getParent() instanceof TryDefinition)) {
            throw new IllegalArgumentException("This doCatch should have a doTry as its parent on " + this.definition);
        }
        Processor childProcessor = this.createChildProcessor(false);
        Predicate when = null;
        if (((CatchDefinition)this.definition).getOnWhen() != null) {
            when = this.createPredicate(((CatchDefinition)this.definition).getOnWhen().getExpression());
        }
        return new CatchProcessor(((CatchDefinition)this.definition).getExceptionClasses(), childProcessor, when, null);
    }

    protected List<Class<? extends Throwable>> createExceptionClasses() throws ClassNotFoundException {
        List list = ((CatchDefinition)this.definition).getExceptions();
        ArrayList<Class<? extends Throwable>> answer = new ArrayList<Class<? extends Throwable>>(list.size());
        for (String name : list) {
            Class type = this.camelContext.getClassResolver().resolveMandatoryClass(name, Throwable.class);
            answer.add(type);
        }
        return answer;
    }
}

