/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ResumableDefinition;
import org.apache.camel.processor.resume.ResumableProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.util.ObjectHelper;

public class ResumableReifier
extends ProcessorReifier<ResumableDefinition> {
    protected ResumableReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ResumableDefinition)ResumableDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor childProcessor = this.createChildProcessor(false);
        ResumeStrategy resumeStrategy = this.resolveResumeStrategy();
        ObjectHelper.notNull((Object)resumeStrategy, (String)"resumeStrategy", (Object)this.definition);
        this.route.setResumeStrategy(resumeStrategy);
        LoggingLevel loggingLevel = this.resolveLoggingLevel();
        return new ResumableProcessor(resumeStrategy, childProcessor, loggingLevel);
    }

    protected ResumeStrategy resolveResumeStrategy() {
        ResumeStrategy strategy = ((ResumableDefinition)this.definition).getResumeStrategyBean();
        if (strategy == null) {
            String ref = this.parseString(((ResumableDefinition)this.definition).getResumeStrategy());
            strategy = this.mandatoryLookup(ref, ResumeStrategy.class);
        }
        return strategy;
    }

    protected LoggingLevel resolveLoggingLevel() {
        LoggingLevel loggingLevel = this.parse(LoggingLevel.class, ((ResumableDefinition)this.definition).getLoggingLevel());
        if (loggingLevel == null) {
            loggingLevel = LoggingLevel.ERROR;
        }
        return loggingLevel;
    }
}

